package io.branch.referral;

import android.content.Context;

import org.json.JSONObject;

/**
 * <p>
 * Abstract for Session init request. All request which do initilaise session should extend from this.
 * </p>
 */
abstract class ServerRequestInitSession extends ServerRequest {
    public ServerRequestInitSession(Context context, String requestPath) {
        super(context, requestPath);
    }
    protected ServerRequestInitSession(String requestPath, JSONObject post, Context context) {
       super(requestPath, post, context);
    }

    /**
     * Check if there is a valid callback to return init session result
     * @return True if a valid call back is present.
     */
    public abstract boolean hasCallBack();
}
