package io.branch.referral;

import android.content.Context;

/**
 * <p>
 * Class for creating builder for getting a referral url with Branch. This builder provide an easy and flexible way to configure and create
 * a referral url synchronously or asynchronously.
 * </p>
 */
public class BranchReferralUrlBuilder extends BranchUrlBuilder<BranchReferralUrlBuilder> {

    public BranchReferralUrlBuilder(Context context, String channel) {
        super(context);
        channel_ = channel;
        type_ = Branch.LINK_TYPE_UNLIMITED_USE;
        feature_ = Branch.FEATURE_TAG_REFERRAL;
    }

    /**
     * <p>Configures and requests a referral URL to be generated by the Branch servers, via a synchronous
     * call.</p>
     *
     * @return A {@link String} containing the resulting referral URL. Null is returned in case of an error or if Branch is not initialised.
     */
    public String getReferralUrl() {
        return super.getUrl();
    }

    /**
     * <p>Configures and requests a referral URL to be generated by the Branch servers, via an asynchronous
     * call; The {@link Branch.BranchLinkCreateListener} is called back with the url when the url is generated.</p>
     *
     * @param callback A {@link Branch.BranchLinkCreateListener} callback instance that will trigger when link is generated.
     */
    public void generateReferralUrl(Branch.BranchLinkCreateListener callback) {
        super.generateUrl(callback);
    }
}
