package io.branch.referral;

import android.content.Context;

/**
 * Created by sojanpr on 8/3/15.
 */
public class BranchContentUrlBuilder extends BranchUrlBuilder<BranchContentUrlBuilder> {

    public BranchContentUrlBuilder(Context context, String channel) {
        super(context);
        channel_ = channel;
        type_ = Branch.LINK_TYPE_UNLIMITED_USE;
        feature_ = Branch.FEATURE_TAG_SHARE;
    }

    /**
     * <p>Configures and requests a content URL to be generated by the Branch servers, via a synchronous
     * call.</p>
     *
     * @return A {@link String} containing the resulting content URL. Null is returned in case of an error or if Branch is not initialised.
     */
    public String getContentUrl() {
        return getUrl();
    }

    /**
     * <p>Configures and requests a content URL to be generated by the Branch servers, via a asynchronous
     * call; The {@link Branch.BranchLinkCreateListener} is called back with the url when the url is generated.</p>
     *
     * @param callback A {@link Branch.BranchLinkCreateListener} callback instance that will trigger
     */
    public void generateContentUrl(Branch.BranchLinkCreateListener callback) {
        super.generateUrl(callback);
    }
}
