/*
 * Decompiled with CFR 0.152.
 */
package io.basestar.event;

import com.google.common.collect.ImmutableList;
import io.basestar.event.Event;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface Emitter {
    public static Emitter skip() {
        return new Skip();
    }

    default public CompletableFuture<?> emit(Event event) {
        return this.emit(event, Collections.emptyMap());
    }

    default public CompletableFuture<?> emit(Event event, Map<String, String> meta) {
        return this.emit(Collections.singletonList(event), meta);
    }

    default public CompletableFuture<?> emit(Collection<? extends Event> events) {
        return this.emit(events, Collections.emptyMap());
    }

    public CompletableFuture<?> emit(Collection<? extends Event> var1, Map<String, String> var2);

    public static class Multi
    implements Emitter {
        private final ImmutableList<Emitter> emitters;

        public Multi(Collection<? extends Emitter> emitters) {
            this.emitters = ImmutableList.copyOf(emitters);
        }

        @Override
        public CompletableFuture<?> emit(Collection<? extends Event> events, Map<String, String> meta) {
            return CompletableFuture.allOf((CompletableFuture[])this.emitters.stream().map(v -> v.emit(events, meta)).toArray(CompletableFuture[]::new));
        }
    }

    public static class Skip
    implements Emitter {
        @Override
        public CompletableFuture<?> emit(Collection<? extends Event> event, Map<String, String> meta) {
            return CompletableFuture.completedFuture(null);
        }
    }
}

