/*
 * Decompiled with CFR 0.152.
 */
package io.basestar.event;

import io.basestar.event.Emitter;
import io.basestar.event.Event;
import io.basestar.event.Handler;
import io.basestar.event.Receiver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Loopback
implements Emitter,
Receiver {
    private static final int DEFAULT_BATCH_SIZE = 50;
    private final ConcurrentLinkedQueue<EventWithMeta> queue = new ConcurrentLinkedQueue();
    private final int batchSize;

    public Loopback() {
        this(50);
    }

    public Loopback(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public CompletableFuture<?> emit(Collection<? extends Event> events, Map<String, String> meta) {
        events.forEach(e -> this.queue.add(new EventWithMeta((Event)e, meta)));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Integer> receive(Handler<Event> handler) {
        EventWithMeta event;
        ArrayList futures = new ArrayList();
        for (int i = 0; i != this.batchSize && (event = this.queue.poll()) != null; ++i) {
            futures.add(handler.handle(event.getEvent(), event.getMeta()));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(ignored -> futures.size());
    }

    private static class EventWithMeta {
        private final Event event;
        private final Map<String, String> meta;

        public EventWithMeta(Event event, Map<String, String> meta) {
            this.event = event;
            this.meta = meta;
        }

        public Event getEvent() {
            return this.event;
        }

        public Map<String, String> getMeta() {
            return this.meta;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventWithMeta)) {
                return false;
            }
            EventWithMeta other = (EventWithMeta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Event this$event = this.getEvent();
            Event other$event = other.getEvent();
            if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
                return false;
            }
            Map<String, String> this$meta = this.getMeta();
            Map<String, String> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EventWithMeta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Event $event = this.getEvent();
            result = result * 59 + ($event == null ? 43 : $event.hashCode());
            Map<String, String> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        public String toString() {
            return "Loopback.EventWithMeta(event=" + this.getEvent() + ", meta=" + this.getMeta() + ")";
        }
    }
}

