/*
 * Decompiled with CFR 0.152.
 */
package io.basestar.event;

import com.google.common.collect.ImmutableList;
import io.basestar.event.Event;
import io.basestar.event.Handler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class Handlers<T> {
    private final List<Mapping<T, ?>> mappings;

    public Handlers(List<Mapping<T, ?>> mappings) {
        this.mappings = ImmutableList.copyOf(mappings);
    }

    public CompletableFuture<?> handle(T self, Event event, Map<String, String> meta) {
        Collection handlers = this.mappings.stream().filter(e -> e.getEvent().equals(event.getClass())).map(Mapping::getHandler).collect(Collectors.toList());
        ArrayList futures = new ArrayList();
        for (UnboundWithMeta handler : handlers) {
            futures.add(handler.handle(self, event, meta));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private final List<Mapping<T, ?>> mappings = new ArrayList();

        public <E extends Event> Builder<T> on(Class<E> event, UnboundWithoutMeta<T, E> handler) {
            this.mappings.add(new Mapping<Object, Event>(event, (self, e, meta) -> handler.handle(self, e)));
            return this;
        }

        public <E extends Event> Builder<T> on(Class<E> event, UnboundWithMeta<T, E> handler) {
            this.mappings.add(new Mapping<T, E>(event, handler));
            return this;
        }

        public <E extends Event> Builder<T> on(Class<E> event, Handler<E> handler) {
            this.mappings.add(new Mapping<Object, Event>(event, (ignored, e, meta) -> handler.handle(e, meta)));
            return this;
        }

        public Handlers<T> build() {
            return new Handlers<T>(this.mappings);
        }
    }

    public static interface UnboundWithoutMeta<T, E extends Event> {
        public CompletableFuture<?> handle(T var1, E var2);
    }

    public static interface UnboundWithMeta<T, E extends Event> {
        public CompletableFuture<?> handle(T var1, E var2, Map<String, String> var3);
    }

    public static class Mapping<T, E extends Event> {
        private final Class<E> event;
        private final UnboundWithMeta<T, E> handler;

        public Mapping(Class<E> event, UnboundWithMeta<T, E> handler) {
            this.event = event;
            this.handler = handler;
        }

        public Class<E> getEvent() {
            return this.event;
        }

        public UnboundWithMeta<T, E> getHandler() {
            return this.handler;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mapping)) {
                return false;
            }
            Mapping other = (Mapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<E> this$event = this.getEvent();
            Class<E> other$event = other.getEvent();
            if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
                return false;
            }
            UnboundWithMeta<T, E> this$handler = this.getHandler();
            UnboundWithMeta<T, E> other$handler = other.getHandler();
            return !(this$handler == null ? other$handler != null : !this$handler.equals(other$handler));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Mapping;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<E> $event = this.getEvent();
            result = result * 59 + ($event == null ? 43 : $event.hashCode());
            UnboundWithMeta<T, E> $handler = this.getHandler();
            result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
            return result;
        }

        public String toString() {
            return "Handlers.Mapping(event=" + this.getEvent() + ", handler=" + this.getHandler() + ")";
        }
    }
}

