/*
 * Decompiled with CFR 0.152.
 */
package io.basestar.event;

import io.basestar.event.Emitter;
import io.basestar.event.Event;
import io.basestar.event.Handler;
import io.basestar.event.Receiver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Loopback
implements Emitter,
Receiver {
    private static final int DEFAULT_BATCH_SIZE = 50;
    private final ConcurrentLinkedQueue<Event> queue = new ConcurrentLinkedQueue();
    private final int batchSize;

    public Loopback() {
        this(50);
    }

    public Loopback(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public CompletableFuture<?> emit(Collection<? extends Event> events) {
        this.queue.addAll(events);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Integer> receive(Handler<Event> handler) {
        Event event;
        ArrayList futures = new ArrayList();
        for (int i = 0; i != this.batchSize && (event = this.queue.poll()) != null; ++i) {
            futures.add(handler.handle(event));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(ignored -> futures.size());
    }
}

