/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.LocalDB;
import io.baltoro.client.RecordList;
import io.baltoro.obj.Base;
import java.util.List;

public class PropertyQuery<T extends Base> {
    private Class<T> c;
    private LocalDB db;
    private StringBuilder q = new StringBuilder();
    private int count;
    private String sortBy;

    PropertyQuery(Class<T> c, LocalDB db) {
        this.c = c;
        this.db = db;
        this.q.append("select uuid from base b where uuid in ");
        this.sortBy = " order by created_on desc ";
    }

    public PropertyQuery<T> addEquals(String name, String value) {
        if (this.count == 0) {
            this.q.append("\n(select distinct base_uuid from metadata where name='" + name + "' and value='" + value + "' and version_uuid=b.latest_version_uuid ");
        } else {
            this.q.append("\n and base_uuid in (select distinct base_uuid from metadata where name='" + name + "' and value='" + value + "' and version_uuid=b.latest_version_uuid ");
        }
        ++this.count;
        return this;
    }

    public PropertyQuery<T> addIn(String name, String value) {
        if (this.count == 0) {
            this.q.append("\n(select distinct base_uuid from metadata where name='" + name + "' and value in (" + value + ") and version_uuid=b.latest_version_uuid ");
        } else {
            this.q.append("\n and base_uuid in (select distinct base_uuid from metadata where name='" + name + "' and value in (" + value + ") and version_uuid=b.latest_version_uuid ");
        }
        ++this.count;
        return this;
    }

    public PropertyQuery<T> sortBy(String sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    public List<T> execute() {
        for (int i = 0; i < this.count; ++i) {
            this.q.append(")");
        }
        String objType = this.db.getType(this.c);
        this.q.append("\nand type='" + objType + "'");
        if (this.sortBy != null) {
            this.q.append("\n" + this.sortBy);
        }
        String query = this.q.toString();
        System.out.println(query);
        RecordList<String> recList = this.db.query(String.class, query).execute();
        if (recList.isEmpty()) {
            return null;
        }
        String[] uuids = recList.toArray((String[])new String[recList.size()]);
        List<T> list = this.db.get(this.c, uuids);
        return list;
    }

    Class<T> getClassT() {
        return this.c;
    }
}

