/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.ep;

import io.baltoro.ep.EPMethodArg;
import java.util.ArrayList;
import java.util.List;

public class EPMethod {
    public String returnObj = "void";
    public String name;
    public List<EPMethodArg> args = new ArrayList<EPMethodArg>();
    public String appName;
    public String path;

    public EPMethod(String returnObj, String name, String appId, String path) {
        if (returnObj != null && returnObj.length() > 0) {
            this.returnObj = returnObj;
        }
        this.name = name;
        this.appName = appId;
        this.path = path;
    }

    public void addArg(String argType, String argName, boolean epReturnType) {
        this.args.add(new EPMethodArg(argType, argName, epReturnType));
    }

    public String getCode() {
        StringBuffer buffer = new StringBuffer();
        StringBuffer epData = new StringBuffer();
        String retunSubType = null;
        buffer.append("\tpublic " + this.returnObj + " " + this.name + "(");
        boolean found = false;
        int count = 0;
        for (EPMethodArg arg : this.args) {
            found = true;
            buffer.append(arg.type + " arg" + ++count + ", ");
            if (!arg.epReturnType) {
                epData.append("\t\tdata.add(\"" + arg.name + "\", arg" + count + ");\r\n");
                continue;
            }
            retunSubType = "arg" + count;
        }
        if (found) {
            buffer.delete(buffer.length() - 2, buffer.length());
        }
        buffer.append(")\n");
        buffer.append("\t{\n");
        buffer.append("\t\tString appName = \"" + this.appName + "\";\r\n");
        buffer.append("\t\tString path = \"" + this.path + "\";\r\n");
        buffer.append("\t\tEPData data = new EPData();\r\n");
        buffer.append(epData.toString());
        buffer.append("\t\tCloudServer server = new CloudServer(appName);\r\n");
        if (retunSubType == null) {
            buffer.append("\t\t" + this.returnObj + " obj = server.execute(path, data, " + this.returnObj + ".class, null);\r\n");
        } else {
            buffer.append("\t\t" + this.returnObj + " obj = server.execute(path, data, " + this.returnObj + ".class, " + retunSubType + ");\r\n");
        }
        buffer.append("\t\treturn obj;\r\n");
        buffer.append("\t}\n");
        return buffer.toString();
    }
}

