/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.baltoro.db.Base;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static boolean isNullOrEmpty(String str) {
        return str == null || str.length() <= 0;
    }

    public static String pad(String text, int count, char c) {
        StringBuilder s = new StringBuilder();
        int cnt = count - text.length();
        if (cnt <= 0) {
            return text;
        }
        s.append(text);
        for (int i = 0; i < cnt; ++i) {
            s.append(c);
        }
        return s.toString();
    }

    public static boolean isNullOrEmpty(Object[] objs) {
        return objs == null || objs.length <= 0;
    }

    public static boolean isNullOrEmpty(Collection<?> col) {
        return col == null || col.size() <= 0;
    }

    public static boolean isNotNullAndNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isNotNullAndNotEmpty(Object[] str) {
        return str != null && str.length > 0;
    }

    public static boolean isNotNullAndNotEmpty(Collection<?> col) {
        return col != null && col.size() > 0;
    }

    public static String stripPhoneNumber(String phoneNumber) {
        StringBuffer str = new StringBuffer();
        char[] chars = phoneNumber.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c < '0' || c > '9') continue;
            str.append(chars[i]);
        }
        return str.toString();
    }

    public static String encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] decode(String str) {
        return Base64.getDecoder().decode(str);
    }

    public static String[] toUuids(Base[] objs) {
        String[] uuids = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            uuids[i] = objs[i] == null ? null : objs[i].getBaseUuid();
        }
        return uuids;
    }

    public static String toInClause(String[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(array.length * 10);
        for (String val : array) {
            buffer.append("'" + val + "',");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    public static String toInClauseFromBase(List<Base> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(list.size() * 10);
        for (Base val : list) {
            buffer.append("'" + val.getBaseUuid() + "',");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    public static String toInClause(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(list.size() * 10);
        for (String val : list) {
            buffer.append("'" + val + "',");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    public static String toInClause(Base ... bases) {
        StringBuilder buffer = new StringBuilder(bases.length * 10);
        for (Base base : bases) {
            buffer.append("'" + base.getBaseUuid() + "',");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    public static String toInClause(Collection<String> col) {
        if (col == null || col.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(col.size() * 10);
        for (String val : col) {
            buffer.append("'" + val + "',");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    public static String toInClauseForMetadata(Collection<Base> col) {
        if (col == null || col.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(col.size() * 10);
        for (Base val : col) {
            buffer.append("'" + val.getLvUuid() + "',");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    public static String insert(String text, String insert, int period) {
        Pattern p = Pattern.compile("(.{" + period + "})", 32);
        Matcher m = p.matcher(text);
        return m.replaceAll("$1" + insert);
    }

    public static String toJson(Object obj) {
        ObjectMapper m = new ObjectMapper();
        try {
            String json = m.writeValueAsString(obj);
            return json;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

