/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.db;

import io.baltoro.db.Base;
import io.baltoro.db.Link;
import io.baltoro.db.Obj;
import io.baltoro.db.PreparedStatement;
import io.baltoro.db.Session;
import io.baltoro.util.ObjectUtil;
import io.baltoro.util.UUID;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class ObjDerby
extends Obj {
    @Override
    public void createIndex(String tableName, String cols, Session s) {
        String indexName = "idx_" + tableName + "_" + cols.replaceAll(",", "_");
        indexName = indexName.replaceAll("\\(", "");
        indexName = indexName.replaceAll("\\)", "");
        String sql = "CREATE INDEX " + indexName + " on  " + DB_NAME + "." + tableName + "(" + cols + ")";
        System.out.println(sql);
        s.execute(sql);
    }

    private boolean tableNotExists(String tableName) {
        Session s = this.getSession();
        Connection con = s.getConnection();
        try {
            DatabaseMetaData dbmd = con.getMetaData();
            ResultSet rs = dbmd.getTables(DB_NAME, null, tableName.toUpperCase(), null);
            if (rs.next()) {
                System.out.println("Table " + rs.getString("TABLE_NAME") + " already exists !!");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initOP() {
        String home = System.getProperty("user.home");
        try {
            File dir = new File(home + "/mck/db/op");
            if (dir.exists()) {
                FileUtils.deleteDirectory(dir);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Session s = this.getSession();
        try {
            s.execute("create schema " + DB_NAME);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        StringBuffer sql = new StringBuffer();
        if (this.tableNotExists("base")) {
            sql = new StringBuffer();
            sql.append("CREATE TABLE  " + DB_NAME + ".base (");
            sql.append("uuid varchar(64) NOT NULL,");
            sql.append("name varchar(200) NOT NULL,");
            sql.append("type varchar(5) NOT NULL,");
            sql.append("lv_num SMALLINT NOT NULL,");
            sql.append("lv_uuid varchar(64) NOT NULL,");
            sql.append("cont_uuid varchar(64),");
            sql.append("created_on bigint NOT NULL,");
            sql.append("PRIMARY KEY (uuid))");
            s.execute(sql.toString());
            this.createIndex("base", "name", s);
            this.createIndex("base", "type", s);
            System.out.println("Base Table Created");
        }
        if (this.tableNotExists("md")) {
            sql = new StringBuffer();
            sql.append("CREATE TABLE " + DB_NAME + ".md (");
            sql.append("version_uuid varchar(64) NOT NULL,");
            sql.append("name varchar(100) NOT NULL,");
            sql.append("value varchar(2000) NOT NULL)");
            s.execute(sql.toString());
            this.createIndex("md", "version_uuid", s);
            System.out.println("Metadata Table Created");
        }
        if (this.tableNotExists("link")) {
            sql = new StringBuffer();
            sql.append("CREATE TABLE  " + DB_NAME + ".link (");
            sql.append("uuid varchar(64) NOT NULL,");
            sql.append("p_uuid varchar(64) NOT NULL,");
            sql.append("c_uuid varchar(64) NOT NULL,");
            sql.append("p_obj_type varchar(5) NOT NULL,");
            sql.append("c_obj_type varchar(5) NOT NULL,");
            sql.append("sort smallint NOT NULL DEFAULT 50,");
            sql.append("created_on bigint NOT NULL,");
            sql.append("PRIMARY KEY (uuid)) ");
            s.execute(sql.toString());
            this.createIndex("link", "p_uuid", s);
            this.createIndex("link", "c_uuid", s);
            this.createIndex("link", "p_obj_type", s);
            this.createIndex("link", "c_obj_type", s);
            this.createIndex("link", "created_on", s);
            System.out.println("Link Table Created");
        }
        if (this.tableNotExists("mlink")) {
            sql = new StringBuffer();
            sql.append("CREATE TABLE " + DB_NAME + ".mlink (");
            sql.append("uuid varchar(64) NOT NULL,");
            sql.append("base_uuid varchar(64) NOT NULL,");
            sql.append("obj_type varchar(5) NOT NULL,");
            sql.append("obj_count smallint NOT NULL ,");
            sql.append("created_on bigint NOT NULL,");
            sql.append("PRIMARY KEY (uuid,base_uuid)) ");
            s.execute(sql.toString());
            this.createIndex("mlink", "base_uuid", s);
            this.createIndex("mlink", "obj_type", s);
            System.out.println("MLink Table Created");
        }
        if (this.tableNotExists("type")) {
            sql = new StringBuffer();
            sql.append("CREATE TABLE " + DB_NAME + ".type (");
            sql.append("class varchar(200) NOT NULL,");
            sql.append("type varchar(5) NOT NULL,");
            sql.append("created_on timestamp NOT NULL,");
            sql.append("PRIMARY KEY (class)) ");
            System.out.println(sql.toString());
            s.execute(sql.toString());
            this.createIndex("type", "type", s);
            System.out.println("type Table Created");
        }
        if (this.tableNotExists("content")) {
            sql = new StringBuffer();
            sql.append("CREATE TABLE " + DB_NAME + ".content (");
            sql.append("version_uuid varchar(64) NOT NULL,");
            sql.append("name varchar(200) NOT NULL,");
            sql.append("content_type varchar(64) NOT NULL,");
            sql.append("content_size bigint NOT NULL,");
            sql.append("data blob ,");
            sql.append("created_on bigint NOT NULL,");
            sql.append("PRIMARY KEY (version_uuid)) ");
            System.out.println(sql.toString());
            s.execute(sql.toString());
            this.createIndex("content", "name", s);
            System.out.println("Content Table Created");
        }
        if (this.tableNotExists("permission")) {
            sql = new StringBuffer();
            sql.append("CREATE TABLE " + DB_NAME + ".permission (");
            sql.append("uuid varchar(64) NOT NULL,");
            sql.append("base_uuid varchar(64) NOT NULL,");
            sql.append("principal_uuid varchar(64) NOT NULL,");
            sql.append("reader int NOT NULL DEFAULT 0,");
            sql.append("editer int NOT NULL DEFAULT 0,");
            sql.append("owner int NOT NULL DEFAULT 0,");
            sql.append("created_on timestamp NOT NULL,");
            sql.append("PRIMARY KEY (uuid))");
            System.out.println(sql.toString());
            s.execute(sql.toString());
            this.createIndex("permission", "base_uuid", s);
            this.createIndex("permission", "principal_uuid", s);
            System.out.println("Permission Table Created");
        }
        if (this.tableNotExists("inst")) {
            sql = new StringBuffer();
            sql.append("CREATE TABLE " + DB_NAME + ".inst (");
            sql.append("uuid varchar(64) NOT NULL,");
            sql.append("app_uuid varchar(64) NOT NULL,");
            sql.append("last_touch timestamp,");
            sql.append("ip varchar(20),");
            sql.append("PRIMARY KEY (uuid)) ");
            System.out.println(sql.toString());
            s.execute(sql.toString());
            this.createIndex("inst", "last_touch", s);
        }
        if (this.tableNotExists("session")) {
            sql = new StringBuffer();
            sql.append("CREATE TABLE " + DB_NAME + ".session (");
            sql.append("uuid varchar(64) NOT NULL,");
            sql.append("user_uuid varchar(64) NOT NULL,");
            sql.append("user_name varchar(64) NOT NULL,");
            sql.append("roles varchar(256),");
            sql.append("created_on BIGINT,");
            sql.append("touched_on BIGINT,");
            sql.append("ip varchar(20),");
            sql.append("timeout SMALLINT,");
            sql.append("PRIMARY KEY (uuid)) ");
            System.out.println(sql.toString());
            s.execute(sql.toString());
            this.createIndex("session", "created_on", s);
            this.createIndex("session", "touched_on", s);
            this.createIndex("session", "user_uuid", s);
        }
        if (this.tableNotExists("session_history")) {
            sql = new StringBuffer();
            sql.append("CREATE TABLE IF NOT EXISTS " + DB_NAME + ".session_history (");
            sql.append("session_uuid varchar(64) NOT NULL,");
            sql.append("user_uuid varchar(64) NOT NULL,");
            sql.append("user_name varchar(64) NOT NULL,");
            sql.append("roles varchar(256),");
            sql.append("created_on BIGINT,");
            sql.append("touched_on BIGINT,");
            sql.append("ip varchar(20),");
            sql.append("timeout SMALLINT)");
            System.out.println(sql.toString());
        }
        if (this.tableNotExists("request_monitor")) {
            sql = new StringBuffer();
            sql.append("CREATE TABLE " + DB_NAME + ".request_monitor (");
            sql.append("req_uuid varchar(64) NOT NULL,");
            sql.append("app_uuid varchar(64) NOT NULL,");
            sql.append("client_uuid varchar(64) NOT NULL,");
            sql.append("type varchar(37) NOT NULL,");
            sql.append("cmd varchar(256) NOT NULL,");
            sql.append("url varchar(64) NOT NULL,");
            sql.append("created_on BIGINT ,");
            sql.append("created_on_date TIMESTAMP ,");
            sql.append("time_taken BIGINT ,");
            sql.append("data_size INT,");
            sql.append("error varchar(256),");
            sql.append("PRIMARY KEY (req_uuid))");
            System.out.println(sql.toString());
            s.execute(sql.toString());
            this.createIndex("request_monitor", "client_uuid", s);
            this.createIndex("request_monitor", "app_uuid", s);
            System.out.println("Request monitoring Table Created");
        }
        if (this.tableNotExists("api_monitor")) {
            sql = new StringBuffer();
            sql.append("CREATE TABLE " + DB_NAME + ".api_monitor (");
            sql.append("req_uuid varchar(64) NOT NULL,");
            sql.append("cmd varchar(256) NOT NULL,");
            sql.append("url varchar(256) NOT NULL,");
            sql.append("created_on bigint,");
            sql.append("time_taken bigint,");
            sql.append("data_size INT,");
            sql.append("error varchar(256),");
            sql.append("PRIMARY KEY (req_uuid))");
            System.out.println(sql.toString());
            s.execute(sql.toString());
            System.out.println("API monitoring Table Created");
        }
        if (this.tableNotExists("ingest")) {
            sql = new StringBuffer();
            sql.append("CREATE TABLE " + DB_NAME + ".ingest (");
            sql.append("bid varchar(64) NOT NULL,");
            sql.append("file_name varchar(256) NOT NULL,");
            sql.append("file_lmo bigint NOT NULL,");
            sql.append("seq int NOT NULL,");
            sql.append("started_on bigint,");
            sql.append("completed_on bigint,");
            sql.append("line_num bigint ,");
            sql.append("percent INT,");
            sql.append("error varchar(250),");
            sql.append("etl_class varchar(64),");
            sql.append("PRIMARY KEY (bid, file_name)) ");
            System.out.println(sql.toString());
            s.execute(sql.toString());
            this.createIndex("ingest", "completed_on", s);
            this.createIndex("ingest", "seq", s);
            System.out.println("ETL Ingest Table Created");
        }
        if (this.tableNotExists("batch")) {
            sql = new StringBuffer();
            sql.append("CREATE TABLE " + DB_NAME + ".batch (");
            sql.append("bid varchar(64) NOT NULL,");
            sql.append("folder varchar(200),");
            sql.append("created_on bigint not null,");
            sql.append("current_seq int,");
            sql.append("max_seq int,");
            sql.append("total_files int,");
            sql.append("processed_files int,");
            sql.append("started_on bigint,");
            sql.append("completed_on bigint,");
            sql.append("PRIMARY KEY (bid)) ");
            System.out.println(sql.toString());
            s.execute(sql.toString());
            this.createIndex("batch", "created_on", s);
            this.createIndex("batch", "started_on", s);
            this.createIndex("batch", "completed_on", s);
            System.out.println("ETL batch Table Created");
        }
        if (this.tableNotExists("customer")) {
            sql = new StringBuffer();
            sql.append("CREATE TABLE " + DB_NAME + ".customer (");
            sql.append("tkn varchar(128) NOT NULL,");
            sql.append("bid varchar(64) NOT NULL,");
            sql.append("created_on BIGINT NOT NULL, ");
            sql.append("uuid varchar(64) NOT NULL) ");
            System.out.println(sql.toString());
            s.execute(sql.toString());
            System.out.println("customer Table Created");
        }
        if (this.tableNotExists("reprocess")) {
            sql = new StringBuffer();
            sql.append("CREATE TABLE " + DB_NAME + ".reprocess (");
            sql.append("uuid varchar(64) NOT NULL,");
            sql.append("bid varchar(64) NOT NULL,");
            sql.append("file_name varchar(128) NOT NULL,");
            sql.append("line_num INT NOT NULL,");
            sql.append("line varchar(1024) NOT NULL,");
            sql.append("created_on BIGINT, ");
            sql.append("process_on BIGINT, ");
            sql.append("PRIMARY KEY (uuid)) ");
            System.out.println(sql.toString());
            s.execute(sql.toString());
            this.createIndex("reprocess", "file_name", s);
            this.createIndex("reprocess", "line_num", s);
            this.createIndex("reprocess", "process_on", s);
            System.out.println("reprocessed_data Table Created");
        }
        if (this.tableNotExists("etl_error")) {
            sql = new StringBuffer();
            sql.append("CREATE TABLE " + DB_NAME + ".etl_error (");
            sql.append("uuid varchar(64) NOT NULL,");
            sql.append("bid varchar(64) NOT NULL,");
            sql.append("file_name varchar(128) NOT NULL,");
            sql.append("line_num int NOT NULL,");
            sql.append("line varchar(1024) NOT NULL,");
            sql.append("created_on BIGINT, ");
            sql.append("PRIMARY KEY (uuid))");
            System.out.println(sql.toString());
            s.execute(sql.toString());
            System.out.println("error_data Table Created");
        }
        try {
            s.getConnection().commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void save(List<Base> objs) {
        Session s = this.getSession();
        PreparedStatement stBase = null;
        PreparedStatement stMD = null;
        s.execute("LOCK TABLE op.md IN EXCLUSIVE MODE");
        long t = System.currentTimeMillis();
        try {
            for (Base obj : objs) {
                stBase = this.insertBase(obj, s, stBase);
                stMD = this.insertMD(obj, s, stMD);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (stBase != null) {
            stBase.executeBatch();
        }
        System.out.println("base saved " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        if (stMD != null) {
            stMD.executeBatch();
        }
        System.out.println("md saved " + (System.currentTimeMillis() - t));
        try {
            s.getConnection().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(" ======> saved !!! " + Thread.currentThread().getId());
    }

    private PreparedStatement insertBase(Base obj, Session s, PreparedStatement st) {
        if (st == null) {
            st = s.prepare("insert into " + DB_NAME + ".base(uuid, name, type, lv_num, lv_uuid, cont_uuid, created_on)\n values(?,?,?,?,?,?,?) ");
        }
        st.addBatch(obj.getBaseUuid(), obj.getName(), obj.getType(), obj.getLvNum(), obj.getLvUuid(), obj.getTennantUuid(), obj.getCreatedOn());
        return st;
    }

    private PreparedStatement insertMD(Base obj, Session s, PreparedStatement st) {
        Map<String, String> mdMap;
        if (st == null) {
            st = s.prepare("insert into " + DB_NAME + ".md(version_uuid, name, value)\n values (?,?,?)");
        }
        if ((mdMap = this.getMDMap(obj)) == null || mdMap.isEmpty()) {
            return null;
        }
        for (String name : mdMap.keySet()) {
            String value = mdMap.get(name);
            st.addBatch(obj.getLvUuid(), name, value);
        }
        return st;
    }

    @Override
    public void link(List<Link> links) {
        Session s = this.getSession();
        PreparedStatement st = null;
        long t = System.currentTimeMillis();
        for (Link l : links) {
            st = this.insertLink(l.pUuid, l.cUuid, l.sort, s, st);
        }
        if (st != null) {
            st.executeBatch();
        }
        System.out.println("links saved " + (System.currentTimeMillis() - t));
        try {
            s.getConnection().commit();
            s.freeSession();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    PreparedStatement insertLink(String pUuid, String cUuid, int sort, Session s, PreparedStatement st) {
        if (st == null) {
            st = s.prepare("insert into " + DB_NAME + ".link(uuid,p_uuid,c_uuid,p_obj_type,c_obj_type,sort,created_on)  values(?,?,?,?,?,?,?) ");
        }
        String uuid = UUID.baseUuid("LINK");
        String pObjType = ObjectUtil.getType(pUuid);
        String cObjType = ObjectUtil.getType(cUuid);
        st.addBatch(uuid, pUuid, cUuid, pObjType, cObjType, sort, System.currentTimeMillis());
        return st;
    }
}

