/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.db;

import io.baltoro.db.Base;
import io.baltoro.util.StringUtil;
import io.baltoro.util.UUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjCache {
    private static Map<String, Base> uuidCache = new HashMap<String, Base>(100000);
    private static Map<String, List<String>> vuuidCache = new HashMap<String, List<String>>(100000);
    private static Map<String, Long> touch = new HashMap<String, Long>(100000);

    static void addBase(Base b) {
        ObjCache.add(b, true);
    }

    static void addVersion(Base b) {
        ObjCache.add(b, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void add(Base b, boolean isB) {
        String vuuid = b.getLvUuid();
        long ts = System.currentTimeMillis();
        if (isB) {
            uuidCache.put(b.getBaseUuid(), b);
            String key = b.getName().toLowerCase() + b.getTennantUuid() + b.getType();
            uuidCache.put(key, b);
            touch.put(key, ts);
            touch.put(b.getBaseUuid(), ts);
            if (StringUtil.isNotNullAndNotEmpty(b.getId())) {
                uuidCache.put(b.getId() + b.getTennantUuid() + b.getType(), b);
            }
        }
        uuidCache.put(b.getLvUuid(), b);
        touch.put(b.getLvUuid(), ts);
        List<String> list = vuuidCache.get(b.getBaseUuid());
        if (list == null) {
            String key = vuuid + "-sync";
            String string = key.intern();
            synchronized (string) {
                list = vuuidCache.get(b.getBaseUuid());
                if (list == null) {
                    list = new ArrayList<String>(100);
                    vuuidCache.put(b.getBaseUuid(), list);
                }
            }
            list.add(b.getLvUuid());
        }
    }

    static Base get(String uuid) {
        Base b = uuidCache.get(uuid);
        return b;
    }

    static Base get(String name, String contUuid, String type) {
        Base b = uuidCache.get(name + contUuid + type);
        return b;
    }

    static void remove(String uuid) {
        Base b;
        String buuid = null;
        if (!UUID.isBaseUuid(uuid)) {
            buuid = UUID.getBaseUuid(uuid);
        }
        if ((b = uuidCache.get(uuid)) != null) {
            List<String> list = vuuidCache.get(uuid);
            if (StringUtil.isNotNullAndNotEmpty(list)) {
                for (String vuuid : list) {
                    uuidCache.remove(vuuid);
                }
            }
            uuidCache.remove(b.getName() + b.getType());
            uuidCache.remove(b.getId() + b.getType());
        }
        uuidCache.remove(buuid);
        uuidCache.remove(uuid);
        touch.remove(buuid);
    }

    public static void clear() {
        uuidCache.clear();
        vuuidCache.clear();
        touch.clear();
    }
}

