/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.db;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.baltoro.db.Base;
import io.baltoro.db.Content;
import io.baltoro.db.DB;
import io.baltoro.db.DBType;
import io.baltoro.db.Direction;
import io.baltoro.db.Link;
import io.baltoro.db.Linked;
import io.baltoro.db.ObjCache;
import io.baltoro.db.ObjDerby;
import io.baltoro.db.ObjH2;
import io.baltoro.db.ObjM;
import io.baltoro.db.PreparedStatement;
import io.baltoro.db.ResultSet;
import io.baltoro.db.Row;
import io.baltoro.db.Session;
import io.baltoro.db.Store;
import io.baltoro.util.CryptoUtil;
import io.baltoro.util.Log;
import io.baltoro.util.NameValue;
import io.baltoro.util.ObjectUtil;
import io.baltoro.util.StringUtil;
import io.baltoro.util.UUID;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Obj
implements ObjM {
    static Map<DBType, Obj> objMap = new HashMap<DBType, Obj>();
    public static final String BASE_TENNANT = "00000000000000000000000000000000_25187B";
    public static final String BASE_USER = "00000000000000000000000000000000_48101B";
    protected static String DB_NAME = "baltoro";
    protected static DBType DB_TYPE = DBType.MYSQL;
    protected Map<String, String> typeClassMap = new HashMap<String, String>(100);
    protected Map<String, String> classTypeMap = new HashMap<String, String>(100);
    protected Map<String, MDFieldMap> classFieldMap = new HashMap<String, MDFieldMap>(1000);

    protected Obj() {
    }

    protected Session getSession() {
        return DB.getSession(DB_TYPE);
    }

    public static Obj instance() {
        if (DB_TYPE == null) {
            return Obj.instance(DBType.MYSQL);
        }
        return Obj.instance(DB_TYPE);
    }

    public static DBType getDBType() {
        return DB_TYPE;
    }

    public static Obj instance(DBType type) {
        Obj obj = objMap.get((Object)type);
        if (obj == null) {
            String schema = System.getProperty("schema");
            if (StringUtil.isNotNullAndNotEmpty(schema)) {
                DB_NAME = schema;
            }
            switch (type) {
                case DERBY: {
                    obj = new ObjDerby();
                    DB_TYPE = type;
                    break;
                }
                case H2: {
                    obj = new ObjH2();
                    DB_TYPE = type;
                    break;
                }
                case CASSANDRA: {
                    obj = new Obj();
                    DB_TYPE = type;
                    break;
                }
                default: {
                    obj = new Obj();
                }
            }
            DB.dbType = type;
            objMap.put(type, obj);
        }
        return obj;
    }

    public String getDBName() {
        return DB_NAME;
    }

    @Override
    public Obj getImpl() {
        return Obj.instance();
    }

    public <T extends Base> T makeNew(Class<T> t) {
        try {
            T obj = this._makeNew(t);
            String type = this.getTypeByClassName(t.getName());
            ((Base)obj).setType(type);
            String bUuid = UUID.baseUuid(type);
            ((Base)obj).setUuid(bUuid);
            int vNum = 0;
            String vUuid = UUID.versionUuid(bUuid, vNum);
            ((Base)obj).setLvUuid(vUuid);
            ((Base)obj).setLvNum(vNum);
            return (T)((Base)t.cast(obj));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends Base> T _makeNew(Class<T> t) {
        try {
            Base obj = (Base)t.newInstance();
            return (T)((Base)t.cast(obj));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Base __makeNew(Class t) {
        try {
            Base obj = (Base)t.newInstance();
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        this.typeClassMap.clear();
        this.classTypeMap.clear();
        this.classFieldMap.clear();
        ObjCache.clear();
        Session s = this.getSession();
        s.execute("drop database if exists " + DB_NAME);
    }

    public void cleanBIDTables(String bid) {
        Session s = this.getSession();
        Log.log.info(">>>>>>>>>>>>>>>>>>>>>>>> dropping temp tables ... ");
        ResultSet rows = s.execute("select table_name from information_schema.tables  where table_schema='" + DB_NAME + "' ");
        for (Row row : rows) {
            String tname = row.getString("table_name");
            if (!tname.contains(bid)) continue;
            Log.log.info(">>>>>>>>>>>>>>>>>>>>>>>> drop table ... " + tname);
            s.execute("drop table if exists " + DB_NAME + "." + tname);
        }
    }

    public void initSVC() {
        Session s = this.getSession();
        s.execute("create database if not exists " + DB_NAME + " character set UTF8 ");
        StringBuffer sql = new StringBuffer();
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS " + DB_NAME + ".base (");
        sql.append("uuid varchar(64) NOT NULL,");
        sql.append("id varchar(64),");
        sql.append("name varchar(100) NOT NULL,");
        sql.append("type varchar(5) NOT NULL,");
        sql.append("lv_num SMALLINT NOT NULL,");
        sql.append("lv_uuid varchar(64) NOT NULL,");
        sql.append("tennant_uuid varchar(64) NULL,");
        sql.append("created_on bigint NOT NULL,");
        sql.append("PRIMARY KEY (uuid)) ENGINE=MyISAM ");
        s.execute(sql.toString());
        this.createIndex("base", "name(100)", s);
        this.createIndex("base", "created_on", s);
        this.createIndex("base", "type", s);
        this.createIndex("base", "lv_uuid", s);
        this.createIndex("base", "tennant_uuid", s);
        this.createIndex("base", "id", s);
        System.out.println("Base Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS  " + DB_NAME + ".md (");
        sql.append("version_uuid varchar(64) NOT NULL,");
        sql.append("name varchar(100) NOT NULL,");
        sql.append("value varchar(5000) NOT NULL,");
        sql.append("PRIMARY KEY (version_uuid,name)) ENGINE=MyISAM ");
        s.execute(sql.toString());
        this.createIndex("md", "name", s);
        System.out.println("Metadata Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS  " + DB_NAME + ".km (");
        sql.append("uuid varchar(64) NOT NULL,");
        sql.append("app_uuid varchar(64) NOT NULL,");
        sql.append("tennant_uuid varchar(64) NOT NULL,");
        sql.append("api varchar(64) NOT NULL,");
        sql.append("auth varchar(64) NOT NULL,");
        sql.append("ts bigint NOT NULL,");
        sql.append("PRIMARY KEY (uuid)) ENGINE=MyISAM ");
        s.execute(sql.toString());
        this.createIndex("km", "api,auth", s);
        this.createIndex("km", "app_uuid", s);
        this.createIndex("km", "tennant_uuid", s);
        System.out.println("KM Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS  " + DB_NAME + ".link (");
        sql.append("uuid varchar(64) NOT NULL,");
        sql.append("p_uuid varchar(64) NOT NULL,");
        sql.append("c_uuid varchar(64) NOT NULL,");
        sql.append("p_type varchar(5) NOT NULL,");
        sql.append("c_type varchar(5) NOT NULL,");
        sql.append("sort smallint NOT NULL DEFAULT 50,");
        sql.append("created_on bigint NOT NULL,");
        sql.append("PRIMARY KEY (uuid)) ENGINE=MyISAM ");
        s.execute(sql.toString());
        this.createIndex("link", "p_uuid", s);
        this.createIndex("link", "c_uuid", s);
        this.createIndex("link", "p_type", s);
        this.createIndex("link", "c_type", s);
        this.createIndex("link", "created_on", s);
        System.out.println("Link Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS " + DB_NAME + ".mlink (");
        sql.append("uuid varchar(64) NOT NULL,");
        sql.append("base_uuid varchar(64) NOT NULL,");
        sql.append("obj_type varchar(5) NOT NULL,");
        sql.append("obj_count smallint NOT NULL ,");
        sql.append("created_on bigint NOT NULL,");
        sql.append("PRIMARY KEY (uuid,base_uuid)) ENGINE=MyISAM ");
        s.execute(sql.toString());
        this.createIndex("mlink", "base_uuid", s);
        this.createIndex("mlink", "obj_type", s);
        System.out.println("MLink Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS " + DB_NAME + ".type (");
        sql.append("class varchar(200) NOT NULL,");
        sql.append("type varchar(5) NOT NULL,");
        sql.append("created_on timestamp NOT NULL,");
        sql.append("PRIMARY KEY (class)) ENGINE=MyISAM ");
        System.out.println(sql.toString());
        s.execute(sql.toString());
        this.createIndex("type", "type", s);
        System.out.println("type Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS " + DB_NAME + ".content (");
        sql.append("version_uuid varchar(64) NOT NULL,");
        sql.append("name varchar(200) NOT NULL,");
        sql.append("content_type varchar(64) NOT NULL,");
        sql.append("content_size bigint NOT NULL,");
        sql.append("data longblob ,");
        sql.append("created_on bigint NOT NULL,");
        sql.append("PRIMARY KEY (version_uuid)) ENGINE=MyISAM ");
        System.out.println(sql.toString());
        s.execute(sql.toString());
        this.createIndex("content", "name(100)", s);
        System.out.println("Content Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS " + DB_NAME + ".permission (");
        sql.append("uuid varchar(64) NOT NULL,");
        sql.append("base_uuid varchar(64) NOT NULL,");
        sql.append("principal_uuid varchar(64) NOT NULL,");
        sql.append("reader tinyint(1) NOT NULL DEFAULT 0,");
        sql.append("editer tinyint(1) NOT NULL DEFAULT 0,");
        sql.append("owner tinyint(1) NOT NULL DEFAULT 0,");
        sql.append("created_on timestamp NOT NULL,");
        sql.append("PRIMARY KEY (uuid)) ENGINE=MyISAM ");
        System.out.println(sql.toString());
        s.execute(sql.toString());
        this.createIndex("permission", "base_uuid", s);
        this.createIndex("permission", "principal_uuid", s);
        System.out.println("Permission Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS " + DB_NAME + ".inst (");
        sql.append("uuid varchar(64) NOT NULL,");
        sql.append("poll_uuid varchar(64) NOT NULL,");
        sql.append("app_uuid varchar(64) NOT NULL,");
        sql.append("env enum('TEST','PROD'),");
        sql.append("last_touch bigint,");
        sql.append("ip varchar(20),");
        sql.append("PRIMARY KEY (uuid)) ENGINE=MyISAM ");
        System.out.println(sql.toString());
        s.execute(sql.toString());
        this.createIndex("inst", "last_touch", s);
        this.createIndex("inst", "poll_uuid", s);
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS " + DB_NAME + ".session (");
        sql.append("uuid varchar(64) NOT NULL,");
        sql.append("user_id varchar(64) not null,");
        sql.append("user_name varchar(64),");
        sql.append("client_uuid varchar(64),");
        sql.append("app_uuid varchar(64),");
        sql.append("roles varchar(256),");
        sql.append("created_on BIGINT,");
        sql.append("touched_on BIGINT,");
        sql.append("ip varchar(20),");
        sql.append("timeout SMALLINT,");
        sql.append("PRIMARY KEY (uuid)) ENGINE=MyISAM ");
        System.out.println(sql.toString());
        s.execute(sql.toString());
        this.createIndex("session", "created_on", s);
        this.createIndex("session", "touched_on", s);
        this.createIndex("session", "user_uuid", s);
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS " + DB_NAME + ".session_history (");
        sql.append("session_uuid varchar(64) NOT NULL,");
        sql.append("user_uuid varchar(64) NOT NULL,");
        sql.append("user_name varchar(64) NOT NULL,");
        sql.append("roles varchar(256),");
        sql.append("created_on BIGINT,");
        sql.append("touched_on BIGINT,");
        sql.append("ip varchar(20),");
        sql.append("timeout SMALLINT,");
        sql.append("closed_on bigint,");
        sql.append("day bigint,");
        sql.append("duration_min bigint");
        sql.append(") ENGINE=MyISAM ");
        System.out.println(sql.toString());
        s.execute(sql.toString());
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS " + DB_NAME + ".logs (");
        sql.append("req_uuid varchar(64) NOT NULL,");
        sql.append("app_uuid varchar(64) NOT NULL,");
        sql.append("client_uuid varchar(64) NOT NULL,");
        sql.append("type varchar(37) NOT NULL,");
        sql.append("cmd varchar(256) NOT NULL,");
        sql.append("url varchar(64) NOT NULL,");
        sql.append("created_on BIGINT DEFAULT -2147483648,");
        sql.append("created_on_date TIMESTAMP NULL DEFAULT NULL,");
        sql.append("time_taken BIGINT DEFAULT -2147483648,");
        sql.append("data_size INT,");
        sql.append("error varchar(256),");
        sql.append("PRIMARY KEY (req_uuid),");
        sql.append("INDEX client_uuid_idx (client_uuid),");
        sql.append("INDEX app_uuid_idx (app_uuid),");
        sql.append("INDEX created_date_idx (created_on_date)) ENGINE=MyISAM ");
        System.out.println(sql.toString());
        s.execute(sql.toString());
    }

    public void initOP() {
        Session s = this.getSession();
        s.execute("create database if not exists " + DB_NAME + " character set UTF8 ");
        StringBuffer sql = new StringBuffer();
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS " + DB_NAME + ".base (");
        sql.append("uuid varchar(64) NOT NULL,");
        sql.append("id varchar(64),");
        sql.append("name varchar(200) NOT NULL,");
        sql.append("type varchar(5) NOT NULL,");
        sql.append("lv_num SMALLINT NOT NULL,");
        sql.append("lv_uuid varchar(64) NOT NULL,");
        sql.append("tennant_uuid varchar(64) NULL,");
        sql.append("created_on bigint NOT NULL,");
        sql.append("PRIMARY KEY (uuid)) ENGINE=MyISAM ");
        s.execute(sql.toString());
        this.createIndex("base", "name(100)", s);
        this.createIndex("base", "created_on", s);
        this.createIndex("base", "type", s);
        this.createIndex("base", "lv_uuid", s);
        this.createIndex("base", "tennant_uuid", s);
        this.createIndex("base", "id", s);
        System.out.println("Base Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS  " + DB_NAME + ".md (");
        sql.append("version_uuid varchar(64) NOT NULL,");
        sql.append("name varchar(100) NOT NULL,");
        sql.append("value varchar(2000) NOT NULL,");
        sql.append("PRIMARY KEY (version_uuid,name)) ENGINE=MyISAM ");
        s.execute(sql.toString());
        this.createIndex("md", "name", s);
        this.createIndex("md", "value(200)", s);
        System.out.println("Metadata Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS  " + DB_NAME + ".link (");
        sql.append("uuid varchar(64) NOT NULL,");
        sql.append("p_uuid varchar(64) NOT NULL,");
        sql.append("c_uuid varchar(64) NOT NULL,");
        sql.append("p_type varchar(5) NOT NULL,");
        sql.append("c_type varchar(5) NOT NULL,");
        sql.append("sort smallint NOT NULL DEFAULT 50,");
        sql.append("created_on bigint NOT NULL,");
        sql.append("PRIMARY KEY (uuid)) ENGINE=MyISAM ");
        s.execute(sql.toString());
        this.createIndex("link", "p_uuid", s);
        this.createIndex("link", "c_uuid", s);
        this.createIndex("link", "p_type", s);
        this.createIndex("link", "c_type", s);
        this.createIndex("link", "created_on", s);
        System.out.println("Link Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS " + DB_NAME + ".mlink (");
        sql.append("uuid varchar(64) NOT NULL,");
        sql.append("base_uuid varchar(64) NOT NULL,");
        sql.append("obj_type varchar(5) NOT NULL,");
        sql.append("obj_count smallint NOT NULL ,");
        sql.append("created_on bigint NOT NULL,");
        sql.append("PRIMARY KEY (uuid,base_uuid)) ENGINE=MyISAM ");
        s.execute(sql.toString());
        this.createIndex("mlink", "base_uuid", s);
        this.createIndex("mlink", "obj_type", s);
        System.out.println("MLink Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS " + DB_NAME + ".type (");
        sql.append("class varchar(200) NOT NULL,");
        sql.append("type varchar(5) NOT NULL,");
        sql.append("created_on timestamp NOT NULL,");
        sql.append("PRIMARY KEY (class)) ENGINE=MyISAM ");
        System.out.println(sql.toString());
        s.execute(sql.toString());
        this.createIndex("type", "type", s);
        System.out.println("type Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS " + DB_NAME + ".content (");
        sql.append("version_uuid varchar(64) NOT NULL,");
        sql.append("name varchar(200) NOT NULL,");
        sql.append("content_type varchar(64) NOT NULL,");
        sql.append("content_size bigint NOT NULL,");
        sql.append("data longblob ,");
        sql.append("created_on bigint NOT NULL,");
        sql.append("PRIMARY KEY (version_uuid)) ENGINE=MyISAM ");
        System.out.println(sql.toString());
        s.execute(sql.toString());
        this.createIndex("content", "name(100)", s);
        System.out.println("Content Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS " + DB_NAME + ".permission (");
        sql.append("uuid varchar(64) NOT NULL,");
        sql.append("base_uuid varchar(64) NOT NULL,");
        sql.append("principal_uuid varchar(64) NOT NULL,");
        sql.append("reader tinyint(1) NOT NULL DEFAULT 0,");
        sql.append("editer tinyint(1) NOT NULL DEFAULT 0,");
        sql.append("owner tinyint(1) NOT NULL DEFAULT 0,");
        sql.append("created_on timestamp NOT NULL,");
        sql.append("PRIMARY KEY (uuid)) ENGINE=MyISAM ");
        System.out.println(sql.toString());
        s.execute(sql.toString());
        this.createIndex("permission", "base_uuid", s);
        this.createIndex("permission", "principal_uuid", s);
        System.out.println("Permission Table Created");
        System.out.println(sql.toString());
        s.execute(sql.toString());
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS " + DB_NAME + ".request_monitor (");
        sql.append("req_uuid varchar(64) NOT NULL,");
        sql.append("app_uuid varchar(64) NOT NULL,");
        sql.append("client_uuid varchar(64) NOT NULL,");
        sql.append("type varchar(37) NOT NULL,");
        sql.append("cmd varchar(256) NOT NULL,");
        sql.append("url varchar(64) NOT NULL,");
        sql.append("created_on BIGINT DEFAULT -2147483648,");
        sql.append("created_on_date TIMESTAMP NULL DEFAULT NULL,");
        sql.append("time_taken BIGINT DEFAULT -2147483648,");
        sql.append("data_size INT,");
        sql.append("error varchar(256),");
        sql.append("PRIMARY KEY (req_uuid),");
        sql.append("INDEX client_uuid_idx (client_uuid),");
        sql.append("INDEX app_uuid_idx (app_uuid),");
        sql.append("INDEX created_date_idx (created_on_date)) ENGINE=MyISAM ");
        System.out.println(sql.toString());
        s.execute(sql.toString());
        System.out.println("Request monitoring Table Created");
        sql = new StringBuffer();
        sql.append("CREATE TABLE IF NOT EXISTS " + DB_NAME + ".api_monitor (");
        sql.append("req_uuid varchar(64) NOT NULL,");
        sql.append("cmd varchar(512) NOT NULL,");
        sql.append("url varchar(1024) NOT NULL,");
        sql.append("created_on BIGINT,");
        sql.append("time_taken BIGINT,");
        sql.append("data_size INT,");
        sql.append("error varchar(1024),");
        sql.append("PRIMARY KEY (req_uuid),");
        sql.append("INDEX created_date_idx (created_on)) ENGINE=MyISAM ");
        System.out.println(sql.toString());
        s.execute(sql.toString());
        System.out.println("API monitoring Table Created");
    }

    public void createIndex(String tableName, String cols, Session s) {
        String schema = DB_NAME;
        if (tableName.contains(".")) {
            String[] tkns = tableName.split("\\.");
            schema = tkns[0];
            tableName = tkns[1];
        }
        String _name = CryptoUtil.hash(tableName);
        String indexName = "idx_" + _name;
        indexName = indexName.replaceAll("/", "");
        indexName = indexName.replaceAll("=", "");
        indexName = indexName.replaceAll("\\+", "");
        Row r = s.execute(" SELECT COUNT(1) idx FROM INFORMATION_SCHEMA.STATISTICS  WHERE table_schema='" + schema + "' AND table_name='" + tableName + "' AND index_name='" + indexName + "'").one();
        int count = r.getInt("idx");
        if (count == 0) {
            String sql = "CREATE INDEX " + indexName + " on " + schema + "." + tableName + "(" + cols + ")";
            s.execute(sql);
        }
    }

    public <T extends Base> T get(String baseUuid, Class<T> t) {
        Base obj = this.get(baseUuid);
        if (obj == null) {
            return null;
        }
        return (T)((Base)t.cast(obj));
    }

    public Base get(String baseUuid) {
        if (baseUuid == null) {
            return null;
        }
        Base b = ObjCache.get(baseUuid);
        if (b != null) {
            return b;
        }
        Base obj = null;
        try {
            Session s = this.getSession();
            PreparedStatement st = s.prepare("select * from " + DB_NAME + ".base where uuid = ?");
            Row r = st.execute(baseUuid).one();
            if (r == null) {
                return null;
            }
            String c = this.getClassNameByUuid(baseUuid);
            obj = this.__makeNew(Class.forName(c));
            this.buildBO(r, obj);
            HashMap<String, Base> map = new HashMap<String, Base>();
            map.put(obj.getBaseUuid(), obj);
            this.addtMetadata(map);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ObjCache.addBase(obj);
        return obj;
    }

    public <T extends Base> T getByVersion(String baseUuid, int vNumber, Class<T> t) {
        String vUuid = UUID.versionUuid(baseUuid, vNumber);
        return this.getByVersion(vUuid, t);
    }

    public <T extends Base> T getByVersion(String versionUuid, Class<T> t) {
        Base b = ObjCache.get(versionUuid);
        if (b != null) {
            return (T)((Base)t.cast(b));
        }
        Base obj = null;
        String bUuid = UUID.getBaseUuid(versionUuid);
        int vNum = UUID.getVersionNumber(versionUuid);
        try {
            Session s = this.getSession();
            PreparedStatement st = s.prepare("select * from " + DB_NAME + ".base where uuid=? ");
            Row r = st.execute(bUuid).one();
            if (r == null) {
                return null;
            }
            obj = (Base)t.newInstance();
            this.buildBO(r, obj);
            obj.setLvNum(vNum);
            obj.setLvUuid(versionUuid);
            HashMap<String, Base> map = new HashMap<String, Base>();
            map.put(obj.getBaseUuid(), obj);
            this.addtMetadata(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        ObjCache.addVersion(obj);
        return (T)((Base)t.cast(obj));
    }

    public List<Base> get(String[] baseUuids) {
        try {
            String uuids = StringUtil.toInClause(baseUuids);
            Map<String, Base> map = this.getObjMap(uuids);
            ArrayList<Base> list = new ArrayList<Base>(map.size());
            for (String baseUuid : baseUuids) {
                Base b = map.get(baseUuid);
                if (b == null) continue;
                list.add(b);
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public <T extends Base> List<T> getVersions(Base base, Class<T> c) {
        return this.getVersions(base.getBaseUuid(), c);
    }

    public <T extends Base> List<T> getVersions(String baseUuid, Class<T> c) {
        Session s = this.getSession();
        int vNum = -1;
        ResultSet rs = s.execute("select lv_num from " + DB_NAME + ".base where uuid='" + baseUuid + "'");
        for (Row row : rs) {
            vNum = row.getInt("lv_num");
        }
        ArrayList<T> objs = new ArrayList<T>(vNum);
        for (int i = vNum; i > 0; --i) {
            String vUuid = UUID.versionUuid(baseUuid, i);
            T obj = this.getByVersion(vUuid, c);
            objs.add(obj);
        }
        return objs;
    }

    public <T extends Base> List<T> get(Class<T> c, String[] baseUuids) {
        List<Base> list = this.get(baseUuids);
        return list;
    }

    public List<Base> get(Set<String> baseUuids) {
        String[] uuids = baseUuids.toArray(new String[baseUuids.size()]);
        List<Base> list = this.get(uuids);
        return list;
    }

    public List<Base> get(List<String> baseUuids) {
        String[] uuids = baseUuids.toArray(new String[baseUuids.size()]);
        List<Base> list = this.get(uuids);
        return list;
    }

    private Map<String, Base> getObjMap(String inClasueUuids) throws Exception {
        HashMap<String, Base> objMap = new HashMap<String, Base>(1000);
        Session s = this.getSession();
        String query = "select * from " + DB_NAME + ".base where uuid in (" + inClasueUuids + ")";
        HashMap<String, Base> map = new HashMap<String, Base>();
        ResultSet rs = s.execute(query);
        for (Row r : rs) {
            String baseUuid = r.getString("uuid");
            Base b = ObjCache.get(baseUuid);
            if (b != null) {
                objMap.put(baseUuid, b);
                continue;
            }
            String type = r.getString("type");
            String objClass = this.getClassNameByType(type);
            Base obj = (Base)Class.forName(objClass).newInstance();
            this.buildBO(r, obj);
            objMap.put(obj.getBaseUuid(), obj);
            map.put(obj.getBaseUuid(), obj);
        }
        this.addtMetadata(map);
        return objMap;
    }

    public List<Base> getObjByType(String type, int start, int rowCount) throws Exception {
        HashMap<String, Base> objMap = new HashMap<String, Base>(rowCount + 100);
        ArrayList<Base> list = new ArrayList<Base>(rowCount + 100);
        Session s = this.getSession();
        String query = "select * from " + DB_NAME + ".base where type=? order by created_on limit " + start + "," + rowCount;
        HashMap<String, Base> map = new HashMap<String, Base>();
        PreparedStatement st = s.prepare(query);
        ResultSet rs = st.execute(type);
        for (Row r : rs) {
            String baseUuid = r.getString("uuid");
            Base b = ObjCache.get(baseUuid);
            if (b != null) {
                list.add(b);
                continue;
            }
            String objClass = this.getClassNameByType(type);
            Base obj = (Base)Class.forName(objClass).newInstance();
            this.buildBO(r, obj);
            objMap.put(obj.getBaseUuid(), obj);
            map.put(obj.getBaseUuid(), obj);
            list.add(obj);
        }
        this.addtMetadata(map);
        return list;
    }

    public List<NameValue> getTypes() throws Exception {
        ArrayList<NameValue> list = new ArrayList<NameValue>();
        Session s = this.getSession();
        String q = "select * from " + DB_NAME + ".type";
        ResultSet rs = s.execute(q);
        for (Row r : rs) {
            String n = r.getString("class");
            String v = r.getString("type");
            int idx = n.indexOf(58);
            if (idx != -1) {
                n = n.substring(0, idx);
            }
            NameValue nv = new NameValue(n, v);
            list.add(nv);
        }
        return list;
    }

    public <T extends Base> T getByName(String name, String contUuid, Class t) {
        String type = this.getTypeByClassName(t.getName());
        return this.getByName(name, contUuid, type);
    }

    public <T extends Base> T getByName(String name, String contUuid, String type) {
        Base b = ObjCache.get(name, contUuid, type);
        if (b != null) {
            return (T)b;
        }
        List<T> objList = this.findByName(name, contUuid, type);
        if (objList == null || objList.isEmpty()) {
            return null;
        }
        b = (Base)objList.get(0);
        ObjCache.addBase(b);
        return (T)b;
    }

    public <T extends Base> T getById(String id, String contUuid, Class<T> _class) {
        String type = this.getTypeByClassName(_class.getName());
        return this.getById(id, contUuid, type);
    }

    public <T extends Base> T getById(String id, String contUuid, String type) {
        Base b = ObjCache.get(id, contUuid, type);
        if (b != null) {
            return (T)b;
        }
        List<T> objList = this.findById(id, type);
        if (objList == null || objList.isEmpty()) {
            return null;
        }
        b = (Base)objList.get(0);
        ObjCache.addBase(b);
        return (T)b;
    }

    public <T extends Base> List<T> findByName(String name, String contUuid, Class<T> _class) {
        String type = this.getTypeByClassName(_class.getName());
        return this.findByName(name, contUuid, type);
    }

    public <T extends Base> List<T> findById(String id, Class<T> _class) {
        String type = this.getTypeByClassName(_class.getName());
        return this.findById(id, type);
    }

    public <T extends Base> List<T> findByName(String name, String contUuid, String type) {
        try {
            PreparedStatement st;
            ArrayList<Base> objList = new ArrayList<Base>(200);
            Session s = this.getSession();
            ResultSet rs = null;
            if (StringUtil.isNullOrEmpty(contUuid)) {
                st = s.prepare("select * from " + DB_NAME + ".base where name like ? and type=?");
                rs = st.execute(name, type);
            } else {
                st = s.prepare("select * from " + DB_NAME + ".base where name like ? and type=? and tennant_uuid=?");
                rs = st.execute(name, type, contUuid);
            }
            HashMap<String, Base> map = new HashMap<String, Base>();
            for (Row r : rs) {
                String baseUuid = r.getString("uuid");
                Base obj = ObjCache.get(baseUuid);
                if (obj != null) {
                    objList.add(obj);
                    continue;
                }
                String objClass = this.getClassNameByType(type);
                obj = (Base)Class.forName(objClass).newInstance();
                this.buildBO(r, obj);
                objList.add(obj);
                map.put(baseUuid, obj);
            }
            this.addtMetadata(map);
            return objList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends Base> List<T> findById(String id, String type) {
        try {
            ArrayList<Base> objList = new ArrayList<Base>(200);
            Session s = this.getSession();
            PreparedStatement st = s.prepare("select * from " + DB_NAME + ".base where id=? and type=?");
            HashMap<String, Base> map = new HashMap<String, Base>();
            ResultSet rs = st.execute(id, type);
            for (Row r : rs) {
                String baseUuid = r.getString("uuid");
                Base obj = ObjCache.get(baseUuid);
                if (obj != null) {
                    objList.add(obj);
                    continue;
                }
                String objClass = this.getClassNameByType(type);
                obj = (Base)Class.forName(objClass).newInstance();
                this.buildBO(r, obj);
                objList.add(obj);
                map.put(baseUuid, obj);
            }
            this.addtMetadata(map);
            return objList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends Base> T findByPropertyOne(String name, String value, Class<T> _class) {
        List<T> l = this.findByProperty(name, value, _class);
        if (l == null || l.isEmpty()) {
            return null;
        }
        return (T)((Base)_class.cast(l.get(0)));
    }

    public <T extends Base> List<T> findByProperty(String name, String value, Class<T> _class) {
        try {
            String type = this.getTypeByClassName(_class.getName());
            ArrayList<Base> objList = new ArrayList<Base>(200);
            Session s = this.getSession();
            PreparedStatement st = s.prepare("select * from " + DB_NAME + ".base b where type=? and lv_uuid in (select version_uuid from " + DB_NAME + ".md where name=? and value=? )");
            HashMap<String, Base> map = new HashMap<String, Base>();
            ResultSet rs = st.execute(type, name, value);
            for (Row r : rs) {
                String baseUuid = r.getString("uuid");
                Base obj = ObjCache.get(baseUuid);
                if (obj != null) {
                    objList.add(obj);
                    continue;
                }
                String objClass = this.getClassNameByType(type);
                obj = (Base)Class.forName(objClass).newInstance();
                this.buildBO(r, obj);
                objList.add(obj);
                map.put(obj.getBaseUuid(), obj);
            }
            this.addtMetadata(map);
            return objList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public <T extends Base> List<T> find(Class<T> _class) {
        return this.find(_class, null, -1);
    }

    public <T extends Base> List<T> find(Class<T> _class, String orderBy, int limit) {
        try {
            String type = this.getTypeByClassName(_class.getName());
            ArrayList<Base> objList = new ArrayList<Base>(200);
            Session s = this.getSession();
            StringBuffer sql = new StringBuffer();
            sql.append("select * from " + DB_NAME + ".base where type=? ");
            if (StringUtil.isNotNullAndNotEmpty(orderBy)) {
                sql.append(" order by " + orderBy);
            }
            if (limit != -1) {
                sql.append(" limit " + limit);
            }
            PreparedStatement st = s.prepare(sql.toString());
            HashMap<String, Base> map = new HashMap<String, Base>();
            ResultSet rs = st.execute(type);
            for (Row r : rs) {
                String objClass = this.getClassNameByType(type);
                Base obj = (Base)Class.forName(objClass).newInstance();
                this.buildBO(r, obj);
                objList.add(obj);
                map.put(obj.getBaseUuid(), obj);
            }
            this.addtMetadata(map);
            return objList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public <T extends Base> Linked<T> getChildren(Base obj) {
        return this.getChildren(obj.getBaseUuid(), null);
    }

    public <T extends Base> Linked<T> getChildren(Base obj, Class<T> c) {
        return this.getChildren(obj.getBaseUuid(), c);
    }

    public <T extends Base> Linked<T> getChildren(String pUuid, Class<T> c) {
        Linked<T> linked = new Linked<T>(c, pUuid, Direction.CHILD);
        List<String> uuids = this.findLinkedUuid(pUuid, c, Direction.CHILD);
        if (StringUtil.isNullOrEmpty(uuids)) {
            return linked;
        }
        linked.setCount(uuids.size());
        linked.setUuids(uuids);
        return linked;
    }

    public <T extends Base> Linked<T> findChildrenByName(String pUuid, String name, Class<T> c) {
        Linked<T> linked = new Linked<T>(c, pUuid, Direction.CHILD);
        List<String> uuids = this.findLinkedByName(pUuid, name, c, Direction.CHILD);
        if (StringUtil.isNullOrEmpty(uuids)) {
            return linked;
        }
        linked.setCount(uuids.size());
        linked.setUuids(uuids);
        return linked;
    }

    public <T extends Base> Linked<T> getParent(Class<T> c, Base obj) {
        return this.getParent(c, obj.getBaseUuid());
    }

    public <T extends Base> Linked<T> getParent(Class<T> c, String cUuid) {
        Linked<T> linked = new Linked<T>(c, cUuid, Direction.PARENT);
        List<String> uuids = this.findLinkedUuid(cUuid, c, Direction.PARENT);
        if (StringUtil.isNullOrEmpty(uuids)) {
            return linked;
        }
        linked.setCount(uuids.size());
        linked.setUuids(uuids);
        return linked;
    }

    private List<String> findLinkedUuid(String uuid, Class<?> objType, Direction direction) {
        String type = this.getTypeByClassName(objType.getName());
        return this.findLinkedUuid(uuid, type, direction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> findLinkedUuid(String uuid, String type, Direction direction) {
        Session s = this.getSession();
        ArrayList<String> uuidList = new ArrayList<String>(500);
        try {
            PreparedStatement st = null;
            String rfield = "c_uuid";
            String cfield = "p_uuid";
            String tfield = "c_type";
            if (direction == Direction.PARENT) {
                rfield = "p_uuid";
                cfield = "c_uuid";
                tfield = "p_type";
            }
            if (type != null) {
                st = s.prepare("select " + rfield + " from " + DB_NAME + ".link where " + cfield + "=? and " + tfield + "=? order by sort");
                st.setString(2, type);
            } else {
                st = s.prepare("select " + rfield + " from " + DB_NAME + ".link where " + cfield + "=? order by sort");
            }
            st.setString(1, uuid);
            ResultSet rs = st.executeQuery();
            uuidList = new ArrayList(500);
            while (rs.next()) {
                uuidList.add(rs.row().getString(1));
            }
            ArrayList<String> arrayList = uuidList;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uuidList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> findMultiLinkedUuid(Class<?> cObjType, Direction direction, Base ... objs) {
        Session s = this.getSession();
        ArrayList<String> uuidList = new ArrayList<String>(500);
        String inObjs = StringUtil.toInClause(objs);
        try {
            PreparedStatement st = null;
            String rfield = "c_uuid";
            String cfield = "p_uuid";
            String tfield = "p_type";
            if (direction == Direction.PARENT) {
                rfield = "p_uuid";
                cfield = "c_uuid";
                tfield = "c_type";
            }
            if (cObjType != null) {
                st = s.prepare("select " + rfield + " from " + DB_NAME + ".link where " + tfield + "=? and " + cfield + " in (select link_uuid from " + DB_NAME + ".mlink where base_uuid in ('" + inObjs + "') and obj_count=" + objs.length + ") ");
                String type = this.getTypeByClassName(cObjType.getName());
                st.setString(1, type);
            } else {
                st = s.prepare("select " + rfield + " from " + DB_NAME + ".link where " + cfield + " in (select link_uuid from " + DB_NAME + ".mlink where base_uuid in ('" + inObjs + "') and obj_count=" + objs.length + ") ");
            }
            ResultSet rs = st.executeQuery();
            uuidList = new ArrayList(500);
            while (rs.next()) {
                uuidList.add(rs.row().getString(1));
            }
            ArrayList<String> arrayList = uuidList;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uuidList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> findLinkedByName(String uuid, String name, Class<?> cObjType, Direction direction) {
        Session s = this.getSession();
        ArrayList<String> uuidList = new ArrayList<String>(500);
        try {
            String type;
            PreparedStatement st = null;
            if (direction == Direction.CHILD) {
                if (cObjType != null) {
                    st = s.prepare("select uuid from " + DB_NAME + ".base where name=? and uuid in (select c_uuid from " + DB_NAME + ".link where p_uuid = ? and c_type=? )");
                    type = this.getTypeByClassName(cObjType.getName());
                    st.setString(3, type);
                } else {
                    st = s.prepare("select uuid from " + DB_NAME + ".base where name=? and uuid in (select c_uuid from " + DB_NAME + ".link where p_uuid = ? )");
                }
            } else if (cObjType != null) {
                st = s.prepare("select uuid from " + DB_NAME + ".base where name=? and uuid in (select p_uuid from " + DB_NAME + ".link where c_uuid = ? and p_type=?)");
                type = this.getClassNameByType(cObjType.getName());
                st.setString(3, type);
            } else {
                st = s.prepare("select uuid from " + DB_NAME + ".base where name=? and uuid in (select p_uuid from " + DB_NAME + ".link where c_uuid = ?)");
            }
            st.setString(2, uuid);
            st.setString(1, name);
            ResultSet rs = st.executeQuery();
            uuidList = new ArrayList(500);
            while (rs.next()) {
                uuidList.add(rs.row().getString(1));
            }
            ArrayList<String> arrayList = uuidList;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uuidList;
    }

    public String getLinkUuid(String pUuid, String cUuid) {
        Session s = this.getSession();
        String linkUuid = null;
        PreparedStatement st = s.prepare("select uuid from " + DB_NAME + ".link where p_uuid=? and c_uuid=? ");
        Row r = st.execute(pUuid, cUuid).one();
        if (r == null) {
            return null;
        }
        linkUuid = r.getString(1);
        return linkUuid;
    }

    private void addtMetadata(Map<String, Base> objMap) throws Exception {
        if (objMap == null || objMap.isEmpty()) {
            return;
        }
        Session s = this.getSession();
        try {
            String inClause = StringUtil.toInClauseForMetadata(objMap.values());
            ResultSet rs = s.execute("select * from " + DB_NAME + ".md where version_uuid in (" + inClause + ")");
            for (Row r : rs) {
                Method setMethod;
                Methods methods;
                String vUuid = r.getString("version_uuid");
                String bUuid = UUID.getBaseUuid(vUuid);
                String name = r.getString("name");
                String value = r.getString("value");
                Base obj = objMap.get(bUuid);
                MDFieldMap fieldMap = this.classFieldMap.get(obj.getClass().getName());
                if (fieldMap == null) {
                    this.setupMetadataFields(obj);
                    fieldMap = this.classFieldMap.get(obj.getClass().getName());
                }
                if ((methods = (Methods)fieldMap.get(name)) == null || (setMethod = methods.set) == null) continue;
                Class<?> fieldType = methods.field.getType();
                if (fieldType == Integer.TYPE) {
                    int v = Integer.parseInt(value);
                    setMethod.invoke((Object)obj, v);
                    continue;
                }
                if (fieldType == Long.TYPE) {
                    long v = Long.parseLong(value);
                    setMethod.invoke((Object)obj, v);
                    continue;
                }
                if (fieldType == Boolean.TYPE) {
                    boolean v = false;
                    if (value != null && value.equals("true")) {
                        v = true;
                    }
                    setMethod.invoke((Object)obj, v);
                    continue;
                }
                if (fieldType == String.class || fieldType == StringBuffer.class) {
                    setMethod.invoke((Object)obj, value);
                    continue;
                }
                Object paramObj = new ObjectMapper().readValue(value.getBytes(), fieldType);
                setMethod.invoke((Object)obj, paramObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void saveMD(String vUuid, String name, String value) throws Exception {
        Session s = this.getSession();
        PreparedStatement ps = s.prepare("insert into " + DB_NAME + ".md(version_uuid, name, value)  values(?,?,?) ON DUPLICATE KEY UPDATE value=values(value) ");
        ps.execute(vUuid, name, value);
        ObjCache.remove(vUuid);
    }

    public void saveVersion(Base b) {
        Session s = this.getSession();
        StringBuilder insertMD = new StringBuilder(1000);
        insertMD.append("insert into " + DB_NAME + ".md(version_uuid, name, value) values ");
        String objVals = this.getMDValuesST(b);
        if (objVals != null) {
            insertMD.append(objVals);
            insertMD.replace(insertMD.length() - 1, insertMD.length(), " ");
            insertMD.append(" ON DUPLICATE KEY UPDATE name=values(name), value=values(value)");
            s.execute(insertMD.toString());
        }
        ObjCache.remove(b.getBaseUuid());
    }

    private void buildBO(Row r, Base obj) {
        obj.setBaseUuid(r.getString("uuid"));
        obj.setId(r.getString("id"));
        obj.setName(r.getString("name"));
        obj.setType(r.getString("type"));
        obj.setCreatedOn(r.getLong("created_on"));
        obj.setLvNum(r.getInt("lv_num"));
        obj.setLvUuid(r.getString("lv_uuid"));
        obj.setTennantUuid(r.getString("tennant_uuid"));
    }

    public void save(Base obj) {
        if (StringUtil.isNullOrEmpty(obj.getTennantUuid())) {
            throw new RuntimeException("contUuid can't be null for " + obj.toString());
        }
        ObjCache.remove(obj.getBaseUuid());
        ArrayList<Base> list = new ArrayList<Base>();
        list.add(obj);
        this.save(list);
    }

    public void save(List<Base> objs) {
        if (objs == null || objs.isEmpty()) {
            return;
        }
        PreparedStatement ctSt = null;
        Session s = this.getSession();
        int c = 0;
        StringBuilder insertBase = new StringBuilder(objs.size() * 200);
        StringBuilder insertMD = new StringBuilder(objs.size() * 1000);
        insertBase.append("insert into " + DB_NAME + ".base(uuid, id, name, type, lv_num, lv_uuid, tennant_uuid, created_on)   values ");
        insertMD.append("insert into " + DB_NAME + ".md(version_uuid, name, value) values ");
        boolean foundMD = false;
        for (Base obj : objs) {
            StringBuffer hashStr = new StringBuffer(5000);
            ObjCache.remove(obj.getBaseUuid());
            ++c;
            if (StringUtil.isNullOrEmpty(obj.getName())) {
                obj.setName(obj.getBaseUuid());
            }
            obj.setCreatedOn(System.currentTimeMillis());
            String pvUuid = obj.getLvUuid();
            int vn = obj.getLvNum();
            obj.setLvNum(++vn);
            String versionUuid = UUID.versionUuid(obj.getBaseUuid(), vn);
            obj.setLvUuid(versionUuid);
            hashStr.append(obj.getName());
            String baseVals = this.getBaseValuesST(obj);
            insertBase.append(baseVals + ",");
            String objVals = this.getMDValuesST(obj);
            if (objVals != null) {
                foundMD = true;
                insertMD.append(objVals);
            }
            if (!(obj instanceof Content)) continue;
            Content ct = (Content)obj;
            if (ct.getLvNum() > 1 && ct.getData() == null) {
                byte[] bytes = this.getContent(pvUuid);
                ct.setData(bytes);
            }
            ctSt = this.insertContent((Content)obj, s, ctSt);
        }
        insertBase.replace(insertBase.length() - 1, insertBase.length(), " ");
        insertBase.append(" ON DUPLICATE KEY UPDATE id=values(id), name=values(name), lv_num=values(lv_num), lv_uuid=values(lv_uuid), tennant_uuid=values(tennant_uuid), created_on=values(created_on) ");
        s.execute(insertBase.toString());
        System.out.println("base saved .............. " + c);
        if (foundMD) {
            insertMD.replace(insertMD.length() - 1, insertMD.length(), " ");
            insertMD.append(" ON DUPLICATE KEY UPDATE name=values(name), value=values(value), version_uuid=values(version_uuid)");
            s.execute(insertMD.toString());
        }
        System.out.println("md saved .............. " + c);
        if (ctSt != null) {
            ctSt.executeBatch();
        }
        System.out.println("content saved .............. " + c);
        if (ctSt != null) {
            ctSt.close();
        }
    }

    public Map<String, String> getNamesByType(String type) {
        Session s = this.getSession();
        int cnt = s.execute("select count(*) from " + DB_NAME + ".base where type='" + type + "'").one().getInt(0);
        HashMap<String, String> map = new HashMap<String, String>(cnt + 10000);
        ResultSet rs = s.execute("select uuid,name from " + DB_NAME + ".base where type='" + type + "'");
        for (Row r : rs) {
            String bUuid = r.getString("uuid");
            String name = r.getString("name");
            map.put(name, bUuid);
        }
        return map;
    }

    public Map<String, String> getIdsByType(String type) {
        Session s = this.getSession();
        int cnt = s.execute("select count(*) from " + DB_NAME + ".base where type='" + type + "'").one().getInt(0);
        HashMap<String, String> map = new HashMap<String, String>(cnt + 10000);
        ResultSet rs = s.execute("select uuid,id from " + DB_NAME + ".base where type='" + type + "'");
        for (Row r : rs) {
            String bUuid = r.getString("uuid");
            String id = r.getString("id");
            map.put(id, bUuid);
        }
        return map;
    }

    private PreparedStatement updateBase(Base obj, Session s, PreparedStatement st) {
        if (st == null) {
            st = s.prepare("update " + DB_NAME + ".base set id=?, name=?, type=?, lv_num=?, lv_uuid=?, tennant_uuid=? where uuid=? ");
        }
        st.execute(obj.getId(), obj.getName(), obj.getType(), obj.getLvNum(), obj.getLvUuid(), obj.getTennantUuid(), obj.getBaseUuid());
        return st;
    }

    private String getHashValuesST(Base obj, StringBuffer hashStr) {
        String hash = CryptoUtil.hash(hashStr.toString());
        return "('" + hash + "','" + obj.getBaseUuid() + "','" + obj.getType() + "')";
    }

    private String getBaseValuesST(Base obj) {
        String name = null;
        name = obj.getName() == null ? "" + System.currentTimeMillis() : obj.getName().replaceAll("'", "''");
        if (StringUtil.isNullOrEmpty(obj.getId())) {
            return "('" + obj.getBaseUuid() + "',null,'" + name + "','" + obj.getType() + "'," + obj.getLvNum() + ",'" + obj.getLvUuid() + "','" + obj.getTennantUuid() + "'," + obj.getCreatedOn() + ")";
        }
        return "('" + obj.getBaseUuid() + "','" + obj.getId() + "','" + name + "','" + obj.getType() + "'," + obj.getLvNum() + ",'" + obj.getLvUuid() + "','" + obj.getTennantUuid() + "'," + obj.getCreatedOn() + ")";
    }

    private String getMDValuesST(Base obj) {
        Map<String, String> mdMap = this.getMDMap(obj);
        if (mdMap == null || mdMap.isEmpty()) {
            return null;
        }
        StringBuilder str = new StringBuilder(2000);
        for (String name : mdMap.keySet()) {
            String value = mdMap.get(name);
            name = name.replaceAll("'", "''");
            value = value.replaceAll("'", "''");
            str.append("('" + obj.getLvUuid() + "','" + name + "','" + value + "'),");
        }
        return str.toString();
    }

    private void setupMetadataFields(Base obj) throws Exception {
        int i;
        if (obj == null) {
            return;
        }
        if (obj.getClass() == Base.class) {
            return;
        }
        ArrayList classes = new ArrayList();
        Class<?> clazz = obj.getClass();
        classes.add(obj.getClass());
        for (i = 0; i < 10 && (clazz = clazz.getSuperclass()) != Base.class; ++i) {
            classes.add(clazz);
        }
        for (i = classes.size() - 1; i >= 0; --i) {
            Field[] fields;
            Class _class = (Class)classes.get(i);
            for (Field field : fields = _class.getDeclaredFields()) {
                String getMethodName;
                Store storeAnno = field.getAnnotation(Store.class);
                if (storeAnno == null) continue;
                Class<?> fieldType = field.getType();
                String fieldName = field.getName();
                MDFieldMap mdFieldMap = this.classFieldMap.get(obj.getClass().getName());
                if (mdFieldMap == null) {
                    mdFieldMap = new MDFieldMap();
                    this.classFieldMap.put(obj.getClass().getName(), mdFieldMap);
                }
                Method getMethod = null;
                if (fieldType == Boolean.TYPE) {
                    getMethodName = "is" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    getMethod = _class.getMethod(getMethodName, new Class[0]);
                } else {
                    getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    getMethod = _class.getMethod(getMethodName, new Class[0]);
                }
                String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                Method setMethod = _class.getMethod(setMethodName, fieldType);
                Methods methods = new Methods();
                methods.get = getMethod;
                methods.set = setMethod;
                methods.field = field;
                mdFieldMap.put(field.getName(), methods);
            }
        }
    }

    protected Map<String, String> getMDMap(Base obj) {
        HashMap<String, String> mdMap = new HashMap<String, String>();
        try {
            Map fieldMap = this.classFieldMap.get(obj.getClass().getName());
            if (fieldMap == null) {
                this.setupMetadataFields(obj);
                fieldMap = this.classFieldMap.get(obj.getClass().getName());
            }
            if (fieldMap == null) {
                return null;
            }
            Set fieldNames = fieldMap.keySet();
            for (String fieldName : fieldNames) {
                Methods methods = (Methods)fieldMap.get(fieldName);
                Method method = methods.get;
                Class<?> fieldType = methods.field.getType();
                Object mdObj = method.invoke((Object)obj, null);
                String value = null;
                if (mdObj == null) continue;
                value = fieldType.isPrimitive() ? mdObj.toString() : (fieldType == String.class || fieldType == StringBuffer.class || fieldType == StringBuilder.class ? mdObj.toString() : new ObjectMapper().writeValueAsString(mdObj));
                mdMap.put(fieldName, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return mdMap;
    }

    public String getClassNameByUuid(String uuid) {
        String type = ObjectUtil.getType(uuid);
        return this.getClassNameByType(type);
    }

    public String getClassNameByType(String type) {
        String className = this.typeClassMap.get(type);
        if (className != null) {
            int idx = className.indexOf(58);
            if (idx != -1) {
                return className.substring(idx + 1);
            }
            return className;
        }
        Session s = this.getSession();
        PreparedStatement st = s.prepare("select * from " + DB_NAME + ".type where type = ?");
        st.setString(1, type);
        ResultSet rs = st.executeQuery();
        if (rs.next()) {
            Row row = rs.row();
            className = row.getString("class");
        }
        if (className != null) {
            this.classTypeMap.put(className, type);
            this.typeClassMap.put(type, className);
            int idx = className.indexOf(58);
            if (idx != -1) {
                return className.substring(idx + 1);
            }
        }
        return className;
    }

    public String getTypeByClassName(String className) {
        String type = this.classTypeMap.get(className);
        if (type != null) {
            return type;
        }
        Session s = this.getSession();
        PreparedStatement st = s.prepare("select * from " + DB_NAME + ".type where class = ?");
        st.setString(1, className);
        ResultSet rs = st.executeQuery();
        if (rs.next()) {
            Row row = rs.row();
            type = row.getString("type");
        }
        if (type == null) {
            String hash = CryptoUtil.md5(className.getBytes());
            System.out.println(" hash ====> " + hash);
            type = hash.substring(10, 15).toUpperCase();
            st = s.prepare("insert into " + DB_NAME + ".type(class,type,created_on) values (?,?,?)");
            st.execute(className, type, new Timestamp(System.currentTimeMillis()));
        }
        this.classTypeMap.put(className, type);
        this.typeClassMap.put(type, className);
        return type;
    }

    public String link(Base pObj, Base cOobj) {
        try {
            return this.insertLink(pObj.getBaseUuid(), cOobj.getBaseUuid(), 10);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String link(String pUuid, String cUuid) {
        try {
            return this.insertLink(pUuid, cUuid, 10);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String link(String pUuid, String cUuid, int sort) {
        try {
            return this.insertLink(pUuid, cUuid, sort);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void link(List<Link> links) {
        if (links == null || links.isEmpty()) {
            return;
        }
        StringBuilder str = new StringBuilder(links.size() * 80);
        str.append("insert into " + DB_NAME + ".link(uuid, p_uuid, c_uuid, p_type, c_type,sort, created_on) values ");
        for (Link link : links) {
            String pType = ObjectUtil.getType(link.pUuid);
            String cType = ObjectUtil.getType(link.cUuid);
            str.append("('" + link.uuid + "','" + link.pUuid + "','" + link.cUuid + "','" + pType + "','" + cType + "'," + link.sort + "," + System.currentTimeMillis() + "),");
        }
        str.deleteCharAt(str.length() - 1);
        Session s = this.getSession();
        s.execute(str.toString());
    }

    String insertLink(String pUuid, String cUuid, int sort) {
        if (StringUtil.isNullOrEmpty(pUuid) || StringUtil.isNullOrEmpty(cUuid)) {
            throw new RuntimeException("p and c uuid can't be null");
        }
        String lUuid = this.getLinkUuid(pUuid, cUuid);
        if (StringUtil.isNotNullAndNotEmpty(lUuid)) {
            return lUuid;
        }
        Session s = this.getSession();
        PreparedStatement st = s.prepare("insert into " + DB_NAME + ".link(uuid, p_uuid, c_uuid, p_type,c_type,sort, created_on)  values(?,?,?,?,?,?,?) ");
        String linkUuid = UUID.baseUuid("LINK");
        String pObjType = ObjectUtil.getType(pUuid);
        String cObjType = ObjectUtil.getType(cUuid);
        st.setString(1, linkUuid);
        st.setString(2, pUuid);
        st.setString(3, cUuid);
        st.setString(4, pObjType);
        st.setString(5, cObjType);
        st.setInt(6, sort);
        st.setLong(7, System.currentTimeMillis());
        st.execute();
        return linkUuid;
    }

    String insertMLink(Base ... objs) {
        return null;
    }

    public boolean deletLink(String pUuid, String cUuid) throws Exception {
        Session s = this.getSession();
        PreparedStatement st = s.prepare("delete from " + DB_NAME + ".link_att where link_uuid in (select uuid from " + DB_NAME + ".link where p_uuid = ? and c_uuid=?)");
        st.execute(pUuid);
        st = s.prepare("delete from " + DB_NAME + ".link where p_uuid = ? and c_uuid=?");
        st.execute(pUuid, cUuid);
        return true;
    }

    public boolean delete(String baseUuid) {
        ObjCache.remove(baseUuid);
        Session s = this.getSession();
        PreparedStatement st = s.prepare("delete from " + DB_NAME + ".link where p_uuid = ?");
        st.execute(baseUuid);
        st = s.prepare("delete from " + DB_NAME + ".link where c_uuid = ?");
        st.execute(baseUuid);
        String vUuid = baseUuid.substring(0, baseUuid.length() - 1) + "%";
        st = s.prepare("delete from " + DB_NAME + ".md where version_uuid like ?");
        st.execute(vUuid);
        st = s.prepare("delete from " + DB_NAME + ".base where uuid = ?");
        st.execute(baseUuid);
        st = s.prepare("delete from " + DB_NAME + ".content where version_uuid = ?");
        st.execute(vUuid);
        ObjCache.remove(baseUuid);
        return true;
    }

    public boolean deletChildren(String pUuid) throws Exception {
        Session s = this.getSession();
        PreparedStatement st = s.prepare("delete from " + DB_NAME + ".link where p_uuid = ?");
        st.execute(pUuid);
        return true;
    }

    public boolean deletParent(String cUuid) throws Exception {
        Session s = this.getSession();
        PreparedStatement st = s.prepare("delete from " + DB_NAME + ".link where c_uuid=?");
        st.execute(cUuid);
        return true;
    }

    private PreparedStatement insertContent(Content ct, Session s, PreparedStatement st) {
        if (st == null) {
            st = s.prepare("insert into " + DB_NAME + ".content(version_uuid, name, content_type, content_size, data, created_on) values(?,?,?,?,?,?) ON DUPLICATE KEY UPDATE  name=values(name), content_type=values(content_type),  content_size=values(content_size), data=values(data), created_on=values(created_on) ");
        }
        st.execute(ct.getLvUuid(), ct.getName(), ct.getContentType(), ct.getSize(), ct.getData(), System.currentTimeMillis());
        return st;
    }

    public byte[] getContent(Base obj) {
        if (obj == null) {
            return null;
        }
        byte[] bytes = this.getContent(obj.getLvUuid());
        ((Content)obj).setData(bytes);
        return this.getContent(obj.getLvUuid());
    }

    private byte[] getContent(String versionUuid) {
        Session s = this.getSession();
        byte[] bytes = null;
        PreparedStatement st = s.prepare("select data from " + DB_NAME + ".content where version_uuid=?");
        ResultSet rs = st.execute(versionUuid);
        if (rs.next()) {
            bytes = rs.row().getBytes("data");
        }
        return bytes;
    }

    private class Methods {
        Field field;
        Method get;
        Method set;

        private Methods() {
        }
    }

    private class MDFieldMap
    extends HashMap<String, Methods> {
        private static final long serialVersionUID = 5867156521061870546L;

        private MDFieldMap() {
        }
    }
}

