/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.db;

import io.baltoro.db.DB;
import io.baltoro.db.DBType;
import io.baltoro.db.MySQLPS;
import io.baltoro.db.MySQLRS;
import io.baltoro.db.MysqlConnection;
import io.baltoro.db.Obj;
import io.baltoro.db.PreparedStatement;
import io.baltoro.db.ResultSet;
import io.baltoro.db.Session;
import io.baltoro.util.Log;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class MySQLSession
implements Session {
    private Connection con;

    MySQLSession(Connection con) {
        this.con = con;
    }

    @Override
    public Connection getConnection() {
        return this.con;
    }

    @Override
    public void commit() {
        try {
            this.con.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DBType getDBType() {
        return DBType.MYSQL;
    }

    @Override
    public ResultSet execute(String query) {
        try {
            Statement st = this.con.createStatement();
            java.sql.ResultSet rs = null;
            String _query = query.substring(0, 10).toLowerCase().trim();
            if (_query.trim().startsWith("select") || _query.trim().startsWith("show")) {
                rs = st.executeQuery(query);
            } else {
                boolean bl = st.execute(query);
            }
            return new MySQLRS(rs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean executeDDL(String query) {
        try {
            return this.con.createStatement().execute(query);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void freeSession() {
        if (Obj.instance().getDBName().equals("baltoro")) {
            try {
                this.con.close();
                DB.lSession.remove();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            try {
                if (MysqlConnection.inuseCon.contains(this.con.toString())) {
                    MysqlConnection.conns.add(this.con);
                    MysqlConnection.inuseCon.remove(this.con.toString());
                } else {
                    Log.log.info("connection leak  >>>> .. ...... ... " + this.con);
                }
                if (DB.lSession != null) {
                    DB.lSession.remove();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Session test() throws Exception {
        return null;
    }

    @Override
    public PreparedStatement prepare(String q) {
        try {
            java.sql.PreparedStatement st = this.con.prepareStatement(q);
            return new MySQLPS(st, q);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PreparedStatement prepareForAutoGen(String q) {
        try {
            java.sql.PreparedStatement st = this.con.prepareStatement(q, 1);
            MySQLPS ps = new MySQLPS(st, q);
            ps.hasAutoIncrement = true;
            return ps;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            String env = System.getProperty("spaceship.env");
            if (env.equals("outpost")) {
                this.freeSession();
            } else {
                this.con.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

