/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.db;

import io.baltoro.db.Base;
import io.baltoro.db.Direction;
import io.baltoro.db.Obj;
import io.baltoro.util.StringUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Linked<T extends Base> {
    private String srcUuid;
    private Direction direction;
    private int count;
    private List<String> uuids;
    private List<T> objs;
    private Map<String, Set<String>> attUuidMap;
    private Map<String, Set<Base>> attObjMap;
    private Class<T> c;
    private int index;

    Linked(Class<T> c, String srcUuid, Direction direction) {
        this.c = c;
        this.srcUuid = srcUuid;
        this.direction = direction;
    }

    public List<String> getUuids() {
        return this.uuids;
    }

    void setUuids(List<String> uuids) {
        this.uuids = uuids;
    }

    public int getCount() {
        return this.count;
    }

    void setCount(int count) {
        this.count = count;
    }

    public List<T> getList() {
        return this.objs;
    }

    void setList(List<T> list) {
        this.objs = list;
    }

    public String getFirstUuid() {
        if (this.uuids == null || this.uuids.isEmpty()) {
            return null;
        }
        return this.uuids.get(0);
    }

    public T getFirst() {
        if (this.uuids == null || this.uuids.isEmpty()) {
            return null;
        }
        this.getAll();
        return (T)((Base)this.objs.get(0));
    }

    public List<T> getAll() {
        if (StringUtil.isNullOrEmpty(this.uuids)) {
            return new ArrayList();
        }
        if (this.objs == null) {
            List<Base> objs = Obj.instance().get(this.uuids);
            this.setList(objs);
        }
        return this.objs;
    }

    public T[] getAllAsArray() {
        this.getAll();
        Object[] arr = (Object[])Array.newInstance(this.c, this.objs.size());
        return (Base[])this.objs.toArray(arr);
    }

    public String[] getUuidsAsArray() {
        return this.uuids.toArray(new String[this.uuids.size()]);
    }

    public Class<T> getType() {
        return this.c;
    }
}

