/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.db;

import io.baltoro.db.DBType;
import io.baltoro.db.DerbyRS;
import io.baltoro.db.H2Connection;
import io.baltoro.db.H2PS;
import io.baltoro.db.Obj;
import io.baltoro.db.PreparedStatement;
import io.baltoro.db.ResultSet;
import io.baltoro.db.Session;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class H2Session
implements Session {
    private Connection con;

    H2Session(Connection con) {
        this.con = con;
    }

    @Override
    public Connection getConnection() {
        return this.con;
    }

    @Override
    public void commit() {
        try {
            this.con.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DBType getDBType() {
        return DBType.H2;
    }

    @Override
    public ResultSet execute(String query) {
        try {
            Statement st = this.con.createStatement();
            java.sql.ResultSet rs = null;
            String _query = query.substring(0, 10).toLowerCase().trim();
            if (_query.startsWith("select")) {
                rs = st.executeQuery(query);
            } else {
                boolean bl = st.execute(query);
            }
            return new DerbyRS(rs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean executeDDL(String query) {
        try {
            return this.con.createStatement().execute(query);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void freeSession() {
        if (Obj.instance().getDBName().equals("ss")) {
            try {
                this.con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (Obj.instance().getDBName().equals("op")) {
            try {
                H2Connection.tlCon.remove();
                H2Connection.conns.add(this.con);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Session test() throws Exception {
        return null;
    }

    @Override
    public PreparedStatement prepare(String q) {
        try {
            java.sql.PreparedStatement st = this.con.prepareStatement(q);
            return new H2PS(st, q);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PreparedStatement prepareForAutoGen(String q) {
        try {
            java.sql.PreparedStatement st = this.con.prepareStatement(q, 1);
            return new H2PS(st, q);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.con.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

