/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.db;

import io.baltoro.db.DB;
import io.baltoro.db.DBType;
import io.baltoro.db.Obj;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.h2.tools.Server;

public class H2Connection {
    static ConcurrentLinkedQueue<Connection> conns = new ConcurrentLinkedQueue();
    static ThreadLocal<Connection> tlCon = new ThreadLocal();
    static Connection conn;
    static Server server;

    public static Connection getConnection() {
        String dbName = Obj.instance(DBType.H2).getDBName();
        if (dbName.equals("op")) {
            return H2Connection.getLocalConnection();
        }
        throw new RuntimeException("Database name should be OP ");
    }

    public static Connection getLocalConnection() {
        try {
            Connection conn;
            String home = System.getProperty("user.home");
            Class.forName("org.h2.Driver").newInstance();
            File f = new File(home + "/mck/db");
            if (!f.exists()) {
                f.mkdirs();
            }
            if (server == null) {
                // empty if block
            }
            if ((conn = tlCon.get()) == null && (conn = conns.poll()) == null) {
                Properties props = new Properties();
                props.put("create", "true");
                conn = DriverManager.getConnection("jdbc:h2:" + home + "/mck/db/op;LOG=0;CACHE_SIZE=65536000;LOCK_MODE=0;UNDO_LOG=0;MULTI_THREADED=1;WRITE_DELAY=1000");
                conn.setAutoCommit(true);
                conn.setCatalog("op");
                ++DB.conCreateCount;
            }
            return conn;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

