/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.db;

import io.baltoro.db.DB;
import io.baltoro.db.DBType;
import io.baltoro.db.Obj;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.derby.drda.NetworkServerControl;

public class DerbyConnection {
    static ThreadLocal<Connection> tlCon = new ThreadLocal();
    static Connection conn;
    static NetworkServerControl server;

    public static Connection getConnection() {
        String dbName = Obj.instance(DBType.DERBY).getDBName();
        if (dbName.equals("op")) {
            return DerbyConnection.getLocalConnection();
        }
        throw new RuntimeException("Database name should be OP ");
    }

    public static Connection getLocalConnection() {
        try {
            String home = System.getProperty("user.home");
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            Connection conn = tlCon.get();
            if (conn == null) {
                Properties props = new Properties();
                props.put("create", "true");
                conn = DriverManager.getConnection("jdbc:derby:op", props);
                conn.setAutoCommit(true);
                conn.setCatalog("op");
                ++DB.conCreateCount;
            }
            return conn;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

