/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.db;

import io.baltoro.db.Cassandra;
import io.baltoro.db.CassandraSession;
import io.baltoro.db.DBType;
import io.baltoro.db.DerbyConnection;
import io.baltoro.db.DerbySession;
import io.baltoro.db.H2Connection;
import io.baltoro.db.H2Session;
import io.baltoro.db.MySQLSession;
import io.baltoro.db.MysqlConnection;
import io.baltoro.db.Session;
import io.baltoro.util.Log;
import java.sql.Connection;

public class DB {
    static ThreadLocal<Session> lSession = new ThreadLocal();
    public static DBType dbType;
    public static int conCreateCount;

    public static Session getSession() {
        if (dbType == null) {
            return DB.getSession(DBType.MYSQL);
        }
        return DB.getSession(dbType);
    }

    public static Session getCassandraSession() {
        return DB.getSession(DBType.CASSANDRA);
    }

    public static Session getSession(DBType type) {
        if (type == DBType.MYSQL) {
            Session s = lSession.get();
            if (s != null) {
                return s;
            }
            Connection con = MysqlConnection.getConnection();
            s = new MySQLSession(con);
            lSession.set(s);
            return s;
        }
        if (type == DBType.DERBY) {
            Session s = lSession.get();
            if (s != null) {
                return s;
            }
            Connection con = DerbyConnection.getConnection();
            s = new DerbySession(con);
            lSession.set(s);
            return s;
        }
        if (type == DBType.H2) {
            Session s = lSession.get();
            if (s != null) {
                return s;
            }
            Connection con = H2Connection.getConnection();
            s = new H2Session(con);
            lSession.set(s);
            return s;
        }
        com.datastax.driver.core.Session s = Cassandra.instance().getSession();
        return new CassandraSession(s);
    }

    public static void freeSession() {
        try {
            Session session = lSession.get();
            if (session != null) {
                Log.log.info(">>>>>>>>>>>>>>>> ======== freeing session " + session);
                session.freeSession();
            } else {
                Log.log.info(">>>>>>>>>>>>>>>> ======== null session ");
            }
        }
        finally {
            lSession.remove();
        }
    }
}

