/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.db;

import com.datastax.driver.core.Cluster;
import io.baltoro.db.Cassandra;
import io.baltoro.db.CassandraPS;
import io.baltoro.db.CassandraRS;
import io.baltoro.db.DBType;
import io.baltoro.db.PreparedStatement;
import io.baltoro.db.ResultSet;
import io.baltoro.db.Session;
import java.io.IOException;
import java.sql.Connection;

public class CassandraSession
implements Session {
    private com.datastax.driver.core.Session session;

    CassandraSession(com.datastax.driver.core.Session session) {
        this.session = session;
    }

    @Override
    public Connection getConnection() {
        return null;
    }

    @Override
    public DBType getDBType() {
        return DBType.CASSANDRA;
    }

    @Override
    public ResultSet execute(String query) {
        com.datastax.driver.core.ResultSet rs = this.session.execute(query);
        return new CassandraRS(rs);
    }

    @Override
    public void freeSession() {
    }

    @Override
    public Session test() throws Exception {
        this.session = Cassandra.instance().test();
        return new CassandraSession(this.session);
    }

    public Cluster getCluster() {
        return this.session.getCluster();
    }

    @Override
    public void commit() {
    }

    @Override
    public PreparedStatement prepare(String q) {
        com.datastax.driver.core.PreparedStatement st = this.session.prepare(q);
        return new CassandraPS(st, this.session);
    }

    @Override
    public PreparedStatement prepareForAutoGen(String q) {
        return this.prepare(q);
    }

    @Override
    public boolean executeDDL(String query) {
        throw new RuntimeException("not impl yet ");
    }

    @Override
    public void close() throws IOException {
        System.out.println("do nothing ... ");
    }
}

