/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.db;

public class CassandraProperties {
    public static String getProps(String localIP, String seedIp) {
        String dataDir = System.getProperty("user.home") + "/mck/mhybrid-client-" + localIP;
        StringBuffer str = new StringBuffer();
        str.append("# Cassandra storage config YAML\r\n");
        str.append("cluster_name: 'Test Cluster'\r\n");
        str.append("hinted_handoff_enabled: true\r\n");
        str.append("max_hint_window_in_ms: 10800000\r\n");
        str.append("hinted_handoff_throttle_in_kb: 1024\r\n");
        str.append("max_hints_delivery_threads: 2\r\n");
        str.append("hints_directory: " + dataDir + "/hints\r\n");
        str.append("authenticator: AllowAllAuthenticator\r\n");
        str.append("authorizer: AllowAllAuthorizer\r\n");
        str.append("permissions_validity_in_ms: 2000\r\n");
        str.append("partitioner: org.apache.cassandra.dht.Murmur3Partitioner\r\n");
        str.append("data_file_directories:\r\n");
        str.append("    - " + dataDir + "/data\r\n");
        str.append("commitlog_directory: " + dataDir + "/commitlog\r\n");
        str.append("cdc_raw_directory: " + dataDir + "/cdc\r\n");
        str.append("disk_failure_policy: stop\r\n");
        str.append("key_cache_size_in_mb:\r\n");
        str.append("key_cache_save_period: 14400\r\n");
        str.append("row_cache_size_in_mb: 0\r\n");
        str.append("row_cache_save_period: 0\r\n");
        str.append("saved_caches_directory: " + dataDir + "/saved_caches\r\n");
        str.append("commitlog_sync: periodic\r\n");
        str.append("commitlog_sync_period_in_ms: 10000\r\n");
        str.append("commitlog_segment_size_in_mb: 32\r\n");
        str.append("seed_provider:\r\n");
        str.append("     - class_name: org.apache.cassandra.locator.SimpleSeedProvider\r\n");
        str.append("       parameters:\n");
        str.append("          - seeds: \"" + seedIp + "\"\r\n");
        str.append("concurrent_reads: 32\r\n");
        str.append("concurrent_writes: 32\r\n");
        str.append("trickle_fsync: false\r\n");
        str.append("trickle_fsync_interval_in_kb: 10240\r\n");
        str.append("storage_port: 7010\r\n");
        str.append("ssl_storage_port: 7011\r\n");
        str.append("listen_address: 127.0.0.1\r\n");
        str.append("start_native_transport: true\r\n");
        str.append("native_transport_port: 9142\r\n");
        str.append("start_rpc: true\r\n");
        str.append("rpc_address: localhost\r\n");
        str.append("rpc_port: 9171\r\n");
        str.append("rpc_keepalive: true\r\n");
        str.append("rpc_server_type: sync\r\n");
        str.append("thrift_framed_transport_size_in_mb: 15\r\n");
        str.append("thrift_max_message_length_in_mb: 16\r\n");
        str.append("incremental_backups: false\r\n");
        str.append("snapshot_before_compaction: false\r\n");
        str.append("auto_snapshot: false\r\n");
        str.append("column_index_size_in_kb: 64\r\n");
        str.append("compaction_throughput_mb_per_sec: 16\r\n");
        str.append("read_request_timeout_in_ms: 5000\r\n");
        str.append("range_request_timeout_in_ms: 10000\r\n");
        str.append("write_request_timeout_in_ms: 2000\r\n");
        str.append("cas_contention_timeout_in_ms: 1000\r\n");
        str.append("truncate_request_timeout_in_ms: 60000\r\n");
        str.append("request_timeout_in_ms: 10000\r\n");
        str.append("cross_node_timeout: false\r\n");
        str.append("endpoint_snitch: SimpleSnitch\r\n");
        str.append("dynamic_snitch_update_interval_in_ms: 100\r\n");
        str.append("dynamic_snitch_reset_interval_in_ms: 600000\r\n");
        str.append("dynamic_snitch_badness_threshold: 0.1\r\n");
        str.append("request_scheduler: org.apache.cassandra.scheduler.NoScheduler\r\n");
        str.append("index_interval: 128\r\n");
        str.append("encryption_options:\r\n");
        str.append("    internode_encryption: none\r\n");
        str.append("    keystore: conf/.keystore\r\n");
        str.append("    keystore_password: cassandra\r\n");
        str.append("    truststore: conf/.truststore\r\n");
        str.append("    truststore_password: cassandra\r\n");
        return str.toString();
    }
}

