/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.db;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Session;
import io.baltoro.db.CassandraRS;
import io.baltoro.db.PreparedStatement;
import io.baltoro.db.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CassandraPS
implements PreparedStatement {
    private com.datastax.driver.core.PreparedStatement st;
    private Session s;
    private BatchStatement bt;

    CassandraPS(com.datastax.driver.core.PreparedStatement st, Session s) {
        this.st = st;
        this.s = s;
    }

    @Override
    public ResultSet execute(Object ... objs) {
        BoundStatement bound = this.st.bind(objs);
        com.datastax.driver.core.ResultSet rs = this.s.execute(bound);
        return new CassandraRS(rs);
    }

    @Override
    public ResultSet execute(List<Object> list) {
        BoundStatement bound = this.st.bind(list);
        com.datastax.driver.core.ResultSet rs = this.s.execute(bound);
        return new CassandraRS(rs);
    }

    @Override
    public ResultSet execute(Map<String, Object> map) {
        BoundStatement bt = this.st.bind();
        for (String key : map.keySet()) {
            Object val = map.get(key);
            Class<?> cl = val.getClass();
            if (cl == Integer.class) {
                bt.setInt(key, (int)((Integer)val));
                continue;
            }
            if (cl == Long.class) {
                bt.setLong(key, (long)((Long)val));
                continue;
            }
            if (cl == Timestamp.class) {
                bt.setTimestamp(key, (Date)val);
                continue;
            }
            bt.setString(key, (String)val);
        }
        return null;
    }

    @Override
    public void addBatch(Object ... objs) {
        if (this.bt == null) {
            this.bt = new BatchStatement();
        }
        BoundStatement bst = this.st.bind(objs);
        this.bt.add(bst);
    }

    @Override
    public void addBatch(List<Object> objs) {
        throw new RuntimeException("not supported");
    }

    @Override
    public int executeBatch() {
        com.datastax.driver.core.ResultSet rs = this.s.execute(this.bt);
        return 1;
    }

    @Override
    public void setTimestamp(int idx, Timestamp val) {
        throw new RuntimeException("not impl yet");
    }

    @Override
    public boolean execute() {
        throw new RuntimeException("not impl yet");
    }

    @Override
    public ResultSet executeQuery() {
        throw new RuntimeException("not impl yet");
    }

    @Override
    public void setBytes(int idx, byte[] val) {
        throw new RuntimeException("not impl yet");
    }

    @Override
    public void setInt(int idx, int val) {
        throw new RuntimeException("not impl yet");
    }

    @Override
    public void setLong(int idx, long val) {
        throw new RuntimeException("not impl yet");
    }

    @Override
    public void setString(int idx, String val) {
        throw new RuntimeException("not impl yet");
    }

    @Override
    public void close() {
        throw new RuntimeException("not impl yet");
    }
}

