/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.db;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import io.baltoro.util.Log;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class Cassandra {
    private static Cassandra cassandra;
    private Queue<Session> queue = new ConcurrentLinkedQueue<Session>();
    private Cluster cluster = Cluster.builder().addContactPoint("127.0.0.1").withPort(9042).build();
    private ThreadLocal<Session> lSession = new ThreadLocal();

    private Cassandra() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Cassandra instance() {
        if (cassandra == null) {
            String string = "ServletContainer".intern();
            synchronized (string) {
                cassandra = new Cassandra();
            }
        }
        return cassandra;
    }

    public void addSession(Session session) {
        this.queue.add(session);
    }

    public Session test() throws Exception {
        this.cluster = Cluster.builder().addContactPoint("127.0.0.1").withPort(9042).build();
        return this.cluster.connect();
    }

    public Session getSession() {
        Session session = this.lSession.get();
        if (session == null) {
            session = this.queue.poll();
            if (session == null) {
                Log.log.info("=========================> no session in queue creating one " + Thread.currentThread().getId());
                session = this.cluster.connect();
            }
            Log.log.info("===================================>  " + session + " - " + Thread.currentThread().getId());
        }
        if (session == null) {
            throw new RuntimeException("no session available");
        }
        this.lSession.set(session);
        return session;
    }

    public void freeSession() {
        Session session = this.lSession.get();
        if (session != null) {
            Log.log.info(">>>>>>>>>>>>>>>> ======== freeing session " + session);
            this.queue.add(session);
        }
    }
}

