/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Host;
import com.datastax.driver.core.policies.HostFilterPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;

public class WhiteListPolicy
extends HostFilterPolicy {
    public WhiteListPolicy(LoadBalancingPolicy childPolicy, Collection<InetSocketAddress> whiteList) {
        super(childPolicy, WhiteListPolicy.buildPredicate(whiteList));
    }

    private WhiteListPolicy(LoadBalancingPolicy childPolicy, Predicate<Host> predicate) {
        super(childPolicy, predicate);
    }

    private static Predicate<Host> buildPredicate(Collection<InetSocketAddress> whiteList) {
        final ImmutableSet<InetSocketAddress> hosts = ImmutableSet.copyOf(whiteList);
        return new Predicate<Host>(){

            @Override
            public boolean apply(Host host) {
                return hosts.contains(host.getSocketAddress());
            }
        };
    }

    public static WhiteListPolicy ofHosts(LoadBalancingPolicy childPolicy, String ... hostnames) {
        return WhiteListPolicy.ofHosts(childPolicy, Arrays.asList(hostnames));
    }

    public static WhiteListPolicy ofHosts(LoadBalancingPolicy childPolicy, Iterable<String> hostnames) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String hostname : hostnames) {
            try {
                if (hostname == null) {
                    throw new NullPointerException();
                }
                builder.add(InetAddress.getAllByName(hostname));
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Failed to resolve: " + hostname, e);
            }
        }
        ImmutableCollection addresses = builder.build();
        return new WhiteListPolicy(childPolicy, new Predicate<Host>((ImmutableSet)addresses){
            final /* synthetic */ ImmutableSet val$addresses;
            {
                this.val$addresses = immutableSet;
            }

            @Override
            public boolean apply(Host host) {
                return this.val$addresses.contains(host.getAddress());
            }
        });
    }
}

