/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractMonotonicTimestampGenerator;
import com.datastax.driver.core.TimestampGenerator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoggingMonotonicTimestampGenerator
extends AbstractMonotonicTimestampGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimestampGenerator.class);
    private final long warningThresholdMicros;
    private final long warningIntervalMillis;
    private final AtomicLong lastDriftWarning = new AtomicLong(Long.MIN_VALUE);

    protected LoggingMonotonicTimestampGenerator(long warningThreshold, TimeUnit warningThresholdUnit, long warningInterval, TimeUnit warningIntervalUnit) {
        this.warningThresholdMicros = TimeUnit.MICROSECONDS.convert(warningThreshold, warningThresholdUnit);
        this.warningIntervalMillis = TimeUnit.MILLISECONDS.convert(warningInterval, warningIntervalUnit);
    }

    @Override
    protected void onDrift(long currentTick, long lastTimestamp) {
        long lastWarning;
        long now;
        if (LOGGER.isWarnEnabled() && this.warningThresholdMicros >= 0L && lastTimestamp > currentTick + this.warningThresholdMicros && (now = System.currentTimeMillis()) > (lastWarning = this.lastDriftWarning.get()) + this.warningIntervalMillis && this.lastDriftWarning.compareAndSet(lastWarning, now)) {
            LOGGER.warn("Clock skew detected: current tick ({}) was {} microseconds behind the last generated timestamp ({}), returned timestamps will be artificially incremented to guarantee monotonicity.", currentTick, lastTimestamp - currentTick, lastTimestamp);
        }
    }
}

