/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.APIClient;
import io.baltoro.client.AnnotationProcessor;
import io.baltoro.client.Env;
import io.baltoro.client.LocalDB;
import io.baltoro.client.RequestPoller;
import io.baltoro.client.ResponsePoller;
import io.baltoro.client.ServicePackage;
import io.baltoro.client.SessionManager;
import io.baltoro.client.UserSession;
import io.baltoro.client.WebMethod;
import io.baltoro.client.WebMethodMap;
import io.baltoro.client.util.StringUtil;
import io.baltoro.ep.ClassBuilder;
import io.baltoro.ep.CloudServer;
import io.baltoro.ep.EPData;
import io.baltoro.ep.ParamInput;
import io.baltoro.to.APIError;
import io.baltoro.to.AppTO;
import io.baltoro.to.RequestContext;
import io.baltoro.to.ResponseContext;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.NewCookie;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;

public class Baltoro {
    static Logger log = Logger.getLogger(Baltoro.class.getName());
    static ThreadLocal<String> userSessionIdCtx;
    static UserSession noneUserSession;
    static ThreadLocal<RequestContext> userRequestCtx;
    static ThreadLocal<ResponseContext> userResponseCtx;
    static ThreadLocal<String> serviceNameCtx;
    static Map<String, Class<?>> pathClassMap;
    static Map<String, NewCookie> cookieMap;
    static List<ServicePackage> serviceList;
    static StringBuffer serviceNames;
    static String hostId;
    static APIClient cs;
    static String instanceUuid;
    static int instanceThreadCount;
    static String apiKey;
    static String authCode;
    static String serverURL;
    static String appURL;
    static AppTO appTO;
    static Env env;
    static String pullReplicationServiceNames;
    static ResponsePoller responsePoller;
    private static boolean running;
    static int dbConnectionPoolSize;
    static LocalDB db;
    static String PULL_REPLICATION_SYNC_KEY;
    public static SSLContext sslCtx;

    private static void buildService() throws Exception {
        HashMap<String, WebMethod> pathMap = new HashMap<String, WebMethod>(200);
        AnnotationProcessor p = new AnnotationProcessor();
        for (ServicePackage sp : serviceList) {
            for (String _package : sp.packageNames) {
                Map<String, WebMethod> pMap = p.processAnnotation(sp.serviceName, _package);
                pathMap.putAll(pMap);
            }
            WebMethodMap.getInstance().setMap(pathMap);
        }
    }

    public static LocalDB getDB() {
        if (!running) {
            System.out.println("Baltoro not running, first call Baltoro.start() method ... ");
            System.out.println("Shutting down ... ");
            System.exit(1);
        }
        return LocalDB.instance();
    }

    public static void setDBConnectionPoolSize(int size) {
        dbConnectionPoolSize = size;
    }

    public static String getMainClassName() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        StackTraceElement ste = stElements[stElements.length - 1];
        return ste.getClassName();
    }

    public static String getMainClassPackageName() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        StackTraceElement ste = stElements[stElements.length - 1];
        String className = ste.getClassName();
        System.out.println(" ---- > " + className);
        String[] packs = className.split("\\.");
        if (packs.length > 1) {
            return packs[0] + "." + packs[1];
        }
        return packs[0];
    }

    public static <T> T endPointFactory(Class<T> _class) {
        try {
            Class<?> implClass = pathClassMap.get(_class.getName());
            if (implClass == null) {
                ClassBuilder builder = new ClassBuilder(_class);
                implClass = builder.buildClass();
                pathClassMap.put(_class.getName(), implClass);
            }
            Object obj = implClass.newInstance();
            return _class.cast(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T callSync(String path, Class<T> returnType, ParamInput input) {
        return Baltoro.callSync(Baltoro.appTO.name, path, returnType, input);
    }

    public static <T> T callSync(String path, ParamInput input) {
        return Baltoro.callSync(Baltoro.appTO.name, path, null, input);
    }

    public static <T> T callSync(String path, Class<T> returnType) {
        return Baltoro.callSync(Baltoro.appTO.name, path, returnType, null);
    }

    private static <T> T callSync(String appName, String path, Class<T> returnType, ParamInput input) {
        UserSession session = Baltoro.getUserSession();
        if (session == null) {
            session = noneUserSession;
        }
        if (session == null) {
            noneUserSession = session = Baltoro.createNoneUserSession();
        }
        if (session == null) {
            throw new APIError("no session found in API call : " + path);
        }
        try {
            CloudServer cServer = new CloudServer(appName, session);
            EPData epData = null;
            if (input != null) {
                epData = input.getEPData();
            }
            String url = null;
            if (userRequestCtx == null || userRequestCtx.get() == null) {
                url = appURL;
            } else {
                url = userRequestCtx.get().getUrl();
                int idx1 = url.indexOf("://");
                int idx2 = url.indexOf("/", idx1 + 3);
                url = url.substring(0, idx2);
            }
            T t = cServer.call(url, path, epData, returnType);
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Future<?> callAsync(String path, Class<?> returnType, ParamInput input) {
        return Baltoro.callAsync(Baltoro.appTO.name, path, returnType, input);
    }

    public static Future<?> callAsync(String path, Class<?> returnType) {
        return Baltoro.callAsync(Baltoro.appTO.name, path, returnType, null);
    }

    public static Future<?> callAsync(String appName, String path, Class<?> returnType, ParamInput input) {
        UserSession session = Baltoro.getUserSession();
        if (session == null) {
            session = noneUserSession;
        }
        if (session == null) {
            throw new APIError("no session found in API call : " + path);
        }
        try {
            CloudServer cServer = new CloudServer(appName, session);
            EPData epData = null;
            if (input != null) {
                epData = input.getEPData();
            }
            String url = null;
            if (userRequestCtx == null || userRequestCtx.get() == null) {
                url = appURL;
            } else {
                url = userRequestCtx.get().getUrl();
                int idx1 = url.indexOf("://");
                int idx2 = url.indexOf("/", idx1 + 3);
                url = url.substring(0, idx2);
            }
            Future<?> f = cServer.callAsyn(url, path, epData, returnType);
            return f;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void validateSession(String userName, Set<String> roleNames, int sessionTimeoutMin) {
        String userSessionId = userSessionIdCtx.get();
        if (userSessionId == null) {
            return;
        }
        UserSession userSession = SessionManager.getSession(userSessionId);
        userSession.setUserName(userName);
        userSession.setAuthenticated(true);
        userSession.setRoles(roleNames);
        userSession.setTimeoutMin(sessionTimeoutMin);
        userSession.sendSession();
    }

    public static UserSession getUserSession() {
        String userSessionId = userSessionIdCtx.get();
        if (userSessionId == null) {
            return null;
        }
        UserSession userSession = SessionManager.getSession(userSessionId);
        return userSession;
    }

    static UserSession createNoneUserSession() {
        try {
            UserSession session;
            if (noneUserSession != null) {
                return noneUserSession;
            }
            String bltSessionId = cs.areYouThere();
            noneUserSession = session = SessionManager.getSession(bltSessionId);
            return session;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void invalidateSession() {
        String userSessionId = userSessionIdCtx.get();
        if (userSessionId == null) {
            return;
        }
        UserSession userSession = SessionManager.getSession(userSessionId);
        userSession.setUserName(null);
        userSession.setAuthenticated(false);
        userSession.setRoles(null);
        userSession.attMap = null;
        SessionManager.removeSession(userSessionId);
        userSession.sendSession();
    }

    public static void init(String apiKey, String authCode) {
        String _apiKey;
        String url = System.getProperties().getProperty("url");
        if (StringUtil.isNotNullAndNotEmpty(url)) {
            serverURL = url;
        }
        if (StringUtil.isNotNullAndNotEmpty(_apiKey = System.getProperties().getProperty("apikey"))) {
            apiKey = _apiKey;
        }
        Baltoro.apiKey = apiKey;
        String _authCode = System.getProperties().getProperty("authcode");
        if (StringUtil.isNotNullAndNotEmpty(_authCode)) {
            authCode = _authCode;
        }
        Baltoro.authCode = authCode;
    }

    public static void register(String serviceName, String ... packageNames) {
        if (StringUtil.isNullOrEmpty(serviceName) || serviceName.equals("/")) {
            serviceName = "app_root";
        }
        String[] _packageNames = new String[packageNames.length + 1];
        _packageNames[_packageNames.length - 1] = "io.baltoro.client.APITest";
        for (int i = 0; i < packageNames.length; ++i) {
            _packageNames[i] = packageNames[i];
        }
        ServicePackage sp = new ServicePackage(serviceName, _packageNames);
        serviceList.add(sp);
        serviceNames.append(serviceName + ",");
    }

    public static void pullReplication(String ... serviceName) {
        for (int i = 0; i < serviceName.length; ++i) {
            pullReplicationServiceNames = "service:" + serviceName[i] + " ";
        }
        pullReplicationServiceNames = pullReplicationServiceNames.substring(0, pullReplicationServiceNames.length() - 1);
    }

    private static void setupCerts() throws Exception {
        TrustManagerFactory dtmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        dtmf.init((KeyStore)null);
        X509TrustManager defaultTm = null;
        for (TrustManager tm : dtmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            defaultTm = (X509TrustManager)tm;
            break;
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        byte[] decoded = Base64.getDecoder().decode("MIIE0DCCA7igAwIBAgIBBzANBgkqhkiG9w0BAQsFADCBgzELMAkGA1UEBhMCVVMxEDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxGjAYBgNVBAoTEUdvRGFkZHkuY29tLCBJbmMuMTEwLwYDVQQDEyhHbyBEYWRkeSBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eSAtIEcyMB4XDTExMDUwMzA3MDAwMFoXDTMxMDUwMzA3MDAwMFowgbQxCzAJBgNVBAYTAlVTMRAwDgYDVQQIEwdBcml6b25hMRMwEQYDVQQHEwpTY290dHNkYWxlMRowGAYDVQQKExFHb0RhZGR5LmNvbSwgSW5jLjEtMCsGA1UECxMkaHR0cDovL2NlcnRzLmdvZGFkZHkuY29tL3JlcG9zaXRvcnkvMTMwMQYDVQQDEypHbyBEYWRkeSBTZWN1cmUgQ2VydGlmaWNhdGUgQXV0aG9yaXR5IC0gRzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC54MsQ1K92vdSTYuswZLiBCGzDBNliF44v/z5lz4/OYuY8UhzaFkVLVat4a2ODYpDOD2lsmcgaFItMzEUz6ojcnqOvK/6AYZ15V8TPLvQ/MDxdR/yaFrzDN5ZBUY4RS1T4KL7QjL7wMDge87Am+GZHY23ecSZHjzhHU9FGHbTj3ADqRay9vHHZqm8A29vNMDp5T19MR/gd71vCxJ1gO7GyQ5HYpDNO6rPWJ0+tJYqlxvTV0KaudAVkV4i1RFXULSo6Pvi4vekyCgKUZMQWOlDxSq7neTOvDCAHf+jfBDnCaQJsY1L6d8EbyHSHyLmTGFBUNUtpTrw700kuH9zB0lL7AgMBAAGjggEaMIIBFjAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBBjAdBgNVHQ4EFgQUQMK9J47MNIMwojPX+2yz8LQsgM4wHwYDVR0jBBgwFoAUOpqFBxBnKLbv9r0FQW4gwZTaD94wNAYIKwYBBQUHAQEEKDAmMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5nb2RhZGR5LmNvbS8wNQYDVR0fBC4wLDAqoCigJoYkaHR0cDovL2NybC5nb2RhZGR5LmNvbS9nZHJvb3QtZzIuY3JsMEYGA1UdIAQ/MD0wOwYEVR0gADAzMDEGCCsGAQUFBwIBFiVodHRwczovL2NlcnRzLmdvZGFkZHkuY29tL3JlcG9zaXRvcnkvMA0GCSqGSIb3DQEBCwUAA4IBAQAIfmyTEMg4uJapkEv/oV9PBO9sPpyIBslQj6Zz91cxG7685C/b+LrTW+C05+Z5Yg4MotdqY3MxtfWoSKQ7CC2iXZDXtHwlTxFWMMS2RJ17LJ3lXubvDGGqv+QqG+6EnriDfcFDzkSnE3ANkR/0yBOtg2DZ2HKocyQetawiDsoXiWJYRBuriSUBAA/NxBti21G00w9RKpv0vHP8ds42pM3Z2Czqrpv1KrKQ0U11GIo/ikGQI31bS/6kA1ibRrLDYGCD+H1QQc7CoZDDu+8CL9IVVO5EFdkKrqeKM+2xLXY2JtwE65/3YR8V3Idv7kaWKK2hJn0KCacuBKONvPi8BDAB");
        ByteArrayInputStream in = new ByteArrayInputStream(decoded);
        Certificate ca1 = cf.generateCertificate(in);
        in.close();
        decoded = Base64.getDecoder().decode("MIIEfTCCA2WgAwIBAgIDG+cVMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMSEwHwYDVQQKExhUaGUgR28gRGFkZHkgR3JvdXAsIEluYy4xMTAvBgNVBAsTKEdvIERhZGR5IENsYXNzIDIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwMTAxMDcwMDAwWhcNMzEwNTMwMDcwMDAwWjCBgzELMAkGA1UEBhMCVVMxEDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxGjAYBgNVBAoTEUdvRGFkZHkuY29tLCBJbmMuMTEwLwYDVQQDEyhHbyBEYWRkeSBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eSAtIEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAv3FiCPH6WTT3G8kYo/eASVjpIoMTpsUgQwE7hPHmhUmfJ+r2hBtOoLTbcJjHMgGxBT4HTu70+k8vWTAi56sZVmvigAf88xZ1gDlRe+X5NbZ0TqmNghPktj+pA4P6or6KFWp/3gvDthkUBcrqw6gElDtGfDIN8wBmIsiNaW02jBEYt9OyHGC0OPoCjM7T3UYH3go+6118yHz7sCtTpJJiaVElBWEaRIGMLKlDliPfrDqBmg4pxRyp6V0etp6eMAo5zvGIgPtLXcwy7IViQyU0AlYnAZG0O3AqP26x6JyIAX2f1PnbU21gnb8s51iruF9G/M7EGwM8CetJMVxpRrPgRwIDAQABo4IBFzCCARMwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFDqahQcQZyi27/a9BUFuIMGU2g/eMB8GA1UdIwQYMBaAFNLEsNKR1EwRcbNhyz2h/t2oatTjMDQGCCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZ29kYWRkeS5jb20vMDIGA1UdHwQrMCkwJ6AloCOGIWh0dHA6Ly9jcmwuZ29kYWRkeS5jb20vZ2Ryb290LmNybDBGBgNVHSAEPzA9MDsGBFUdIAAwMzAxBggrBgEFBQcCARYlaHR0cHM6Ly9jZXJ0cy5nb2RhZGR5LmNvbS9yZXBvc2l0b3J5LzANBgkqhkiG9w0BAQsFAAOCAQEAWQtTvZKGEacke+1bMc8dH2xwxbhuvk679r6XUOEwf7ooXGKUwuN+M/f7QnaF25UcjCJYdQkMiGVnOQoWCcWgOJekxSOTP7QYpgEGRJHjp2kntFolfzq3Ms3dhP8qOCkzpN1nsoX+oYggHFCJyNwq9kIDN0zmiN/VryTyscPfzLXs4Jlet0lUIDyUGAzHHFIYSaRt4bNYC8nY7NmuHDKOKHAN4v6mF56ED71XcLNa6R+ghlO773z/aQvgSMO3kwvIClTErF0UZzdsyqUvMQg3qm5vjLyb4lddJIGvl5echK1srDdMZvNhkREg5L4wn3qkKQmw4TRfZHcYQFHfjDCmrw==");
        in = new ByteArrayInputStream(decoded);
        Certificate ca2 = cf.generateCertificate(in);
        in.close();
        decoded = Base64.getDecoder().decode("MIIEADCCAuigAwIBAgIBADANBgkqhkiG9w0BAQUFADBjMQswCQYDVQQGEwJVUzEhMB8GA1UEChMYVGhlIEdvIERhZGR5IEdyb3VwLCBJbmMuMTEwLwYDVQQLEyhHbyBEYWRkeSBDbGFzcyAyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA0MDYyOTE3MDYyMFoXDTM0MDYyOTE3MDYyMFowYzELMAkGA1UEBhMCVVMxITAfBgNVBAoTGFRoZSBHbyBEYWRkeSBHcm91cCwgSW5jLjExMC8GA1UECxMoR28gRGFkZHkgQ2xhc3MgMiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCCASAwDQYJKoZIhvcNAQEBBQADggENADCCAQgCggEBAN6d1+pXGEmhW+vXX0iG6r7d/+TvZxz0ZWizV3GgXne77ZtJ6XCAPVYYYwhv2vLM0D9/AlQiVBDYsoHUwHU9S3/Hd8M+eKsaA7Ugay9qK7HFiH7Eux6wwdhFJ2+qN1j3hybX2C32qRe3H3I2TqYXP2WYktsqbl2i/ojgC95/5Y0V4evLOtXiEqITLdiOr18SPaAIBQi2XKVlOARFmR6jYGB0xUGlcmIbYsUfb18aQr4CUWWoriMYavx4A6lNf4DD+qta/KFApMoZFv6yyO9ecw3ud72a9nmYvLEHZ6IVDd2gWMZEewo+YihfukEHU1jPEX44dMX4/7VpkI+EdOqXG68CAQOjgcAwgb0wHQYDVR0OBBYEFNLEsNKR1EwRcbNhyz2h/t2oatTjMIGNBgNVHSMEgYUwgYKAFNLEsNKR1EwRcbNhyz2h/t2oatTjoWekZTBjMQswCQYDVQQGEwJVUzEhMB8GA1UEChMYVGhlIEdvIERhZGR5IEdyb3VwLCBJbmMuMTEwLwYDVQQLEyhHbyBEYWRkeSBDbGFzcyAyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBADJL87LKPpH8EsahB4yOd6AzBhRckB4Y9wimPQoZ+YeAEW5p5JYXMP80kWNyOO7MHAGjHZQopDH2esRU1/blMVgDoszOYtuURXO1v0XJJLXVggKtI3lpjbi2Tc7PTMozI+gciKqdi0FuFskg5YmezTvacPd+mSYgFFQlq25zheabIZ0KbIIOqPjCDPoQHmyW74cNxA9hi63ugyuV+I6ShHI56yDqg+2DzZduCLzrTia2cyvk0/ZM/iZx4mERdEr/VxqHD3VILs9RaRegAhJhldXRQLIQTO7ErBBDpqWeCtWVYpoNz4iCxTIM5CufReYNnyicsbkqWletNw+vHX/bvZ8=");
        in = new ByteArrayInputStream(decoded);
        Certificate ca3 = cf.generateCertificate(in);
        in.close();
        String keyStoreType = KeyStore.getDefaultType();
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        ks.load(null, null);
        ks.setCertificateEntry("cert1", ca1);
        ks.setCertificateEntry("cert2", ca2);
        ks.setCertificateEntry("cert3", ca3);
        TrustManagerFactory gdtmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        gdtmf.init(ks);
        X509TrustManager gdTm = null;
        for (TrustManager tm : gdtmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            gdTm = (X509TrustManager)tm;
            break;
        }
        TrustManager[] tms = new TrustManager[]{gdTm, defaultTm};
        try {
            sslCtx = SSLContext.getInstance("TLS");
            sslCtx.init(null, tms, new SecureRandom());
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            throw e;
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(sslCtx.getSocketFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        if (env == Env.UT) {
            Baltoro.runLocalTests();
            return;
        }
        try {
            String hostUrl;
            Baltoro.setupCerts();
            Baltoro.setHostId();
            Baltoro.processEnv();
            appURL = serverURL.replace("://" + APIClient.BLTC_CLIENT, "://" + Baltoro.appTO.name);
            Baltoro.buildService();
            cs.sendAppAPI();
            RequestPoller.instance();
            responsePoller = new ResponsePoller();
            responsePoller.start();
            running = true;
            for (ServicePackage sp : serviceList) {
                log.info("=====================================================");
                log.info("=====================================================");
                if (serverURL.contains("localhost") || serverURL.contains("127.0.0.1") || serverURL.contains("super-server")) {
                    log.info("Test URL --> " + serverURL + "/" + sp.serviceName + "/helloworld?appName=" + Baltoro.getAppName());
                } else {
                    log.info("Test URL --> " + appURL + "/" + sp.serviceName + "/helloworld");
                    hostUrl = appURL.substring(0, appURL.indexOf(46)) + "-hid" + hostId + "" + appURL.substring(appURL.indexOf(46));
                    log.info("Host URL --> " + hostUrl + "/" + sp.serviceName + "/helloworld");
                }
                log.info("HOST ID ====> " + hostId);
                log.info("INST UUID ====> " + instanceUuid);
                log.info("=====================================================");
                log.info("=====================================================");
            }
            System.out.println(" ********** Baltoro lib version ************ ");
            System.out.println(Baltoro.getVersion());
            System.out.println(" ********************** ");
            LocalDB.instance();
            long t0 = System.currentTimeMillis();
            hostUrl = PULL_REPLICATION_SYNC_KEY.intern();
            synchronized (hostUrl) {
                System.out.println("waitng 10 min for replication to finish .... ");
                PULL_REPLICATION_SYNC_KEY.wait(600000L);
            }
            long t1 = System.currentTimeMillis();
            System.out.println(" >>>>>>>>>>>>>>> pull replication finished in (" + (t1 - t0) / 1000L + ") sec ");
            db = LocalDB.instance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getVersion() {
        String v = Baltoro.class.getPackage().getImplementationVersion();
        if (StringUtil.isNullOrEmpty(v)) {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = null;
            try {
                model = reader.read((Reader)new FileReader("pom.xml"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            v = model.getVersion();
        }
        return v;
    }

    public static String getAppName() {
        return Baltoro.appTO.name;
    }

    public static String getPublicURL(boolean https) {
        if (https) {
            return "https://" + Baltoro.getAppName() + ".baltoro.io";
        }
        return "http://" + Baltoro.getAppName() + ".baltoro.io";
    }

    private static void runLocalTests() {
        try {
            Baltoro.setHostId();
            db = LocalDB.instance();
            db.cleanData();
            running = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void setHostId() throws Exception {
        Properties hostProps = new Properties();
        String homeDir = System.getProperty("user.home");
        String hostPropFileName = homeDir + "/baltoro_host.env";
        File hostPropFile = new File(hostPropFileName);
        if (!hostPropFile.exists()) {
            hostPropFile.createNewFile();
        }
        hostProps.load(new FileInputStream(hostPropFile));
        hostId = hostProps.getProperty("baltoro.host.id");
        if (StringUtil.isNullOrEmpty(hostId)) {
            hostId = "" + (999 + new Random().nextInt(8999));
            hostProps.put("baltoro.host.id", hostId);
            FileOutputStream output = new FileOutputStream(hostPropFile);
            hostProps.store(output, "");
        }
    }

    private static void processEnv() throws Exception {
        String logsDir;
        File lf;
        String homeDir = System.getProperty("user.home");
        String bltDir = homeDir + "/baltoro.io";
        File f = new File(bltDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!(lf = new File(logsDir = homeDir + "/baltoro.io/logs")).exists()) {
            lf.mkdirs();
        }
        cs = new APIClient();
        appTO = cs.handShake(apiKey, authCode);
        env = Env.valueOf(Baltoro.appTO.env);
        Properties props = new Properties();
        String propName = Baltoro.getMainClassName();
        String propFileName = bltDir + "/" + propName + "-" + env.toString().toUpperCase() + ".env";
        System.out.println(propFileName);
        File propFile = new File(propFileName);
        if (!propFile.exists()) {
            propFile.createNewFile();
        }
        props.load(new FileInputStream(propFile));
        instanceUuid = props.getProperty("app.instance.uuid");
        String _instanceUuid = cs.createInstance(Baltoro.appTO.uuid, serviceNames.toString(), instanceUuid);
        if (StringUtil.isNullOrEmpty(_instanceUuid) || instanceUuid == null || !instanceUuid.equals(_instanceUuid)) {
            props.put("app.instance.uuid", _instanceUuid);
            instanceUuid = _instanceUuid;
        }
        if (instanceUuid == null || instanceUuid.equals("NOT ALLOWED")) {
            System.out.println("can't find or create an instance exiting " + Baltoro.appTO.name);
            System.exit(1);
        }
        props.put("app.service.names", serviceNames.toString());
        props.put("app.server.url", serverURL);
        FileOutputStream output = new FileOutputStream(propFile);
        props.store(output, "For App " + Baltoro.appTO.name.toUpperCase());
    }

    static String systemIn(String msg) {
        try {
            System.out.print(msg);
            BufferedReader bufferRead = new BufferedReader(new InputStreamReader(System.in));
            String input = bufferRead.readLine();
            return input;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tT:%4$s > %5$s%6$s%n");
        userSessionIdCtx = new ThreadLocal();
        userRequestCtx = new ThreadLocal();
        userResponseCtx = new ThreadLocal();
        serviceNameCtx = new ThreadLocal();
        pathClassMap = new HashMap(100);
        cookieMap = new HashMap<String, NewCookie>(100);
        serviceList = new ArrayList<ServicePackage>();
        serviceNames = new StringBuffer();
        instanceThreadCount = 3;
        serverURL = "https://" + APIClient.BLTC_CLIENT + ".baltoro.io";
        env = Env.PRD;
        running = false;
        dbConnectionPoolSize = 10;
        PULL_REPLICATION_SYNC_KEY = "baltoro-pull-replication";
    }
}

