/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.ColumnMetadata;
import io.baltoro.client.LocalDB;
import io.baltoro.client.Record;
import io.baltoro.client.RecordList;
import io.baltoro.client.util.StringUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;

public class CustomQuery<T> {
    private Class<T> c;
    private String q;
    private Map<String, String> map = new HashMap<String, String>(50);
    private LocalDB db;
    private RecordList<T> rl;
    private boolean executed;

    CustomQuery(Class<T> c, String q, LocalDB db) {
        this.c = c;
        this.q = q;
        this.db = db;
        if (c == String.class) {
            this.map.put("1", "");
        }
    }

    public CustomQuery<T> map(String colName, String propertyName) {
        this.map.put(colName.toLowerCase(), propertyName);
        return this;
    }

    public CustomQuery<T> map(String colName, Field f) {
        this.map.put(colName.toLowerCase(), f.getName());
        return this;
    }

    public RecordList<T> execute() {
        if (!this.executed) {
            this.rl = this.db.executeQuery(this.c, this);
        }
        this.executed = true;
        return this.rl;
    }

    String getQuery() {
        return this.q;
    }

    Class<T> getClassT() {
        return this.c;
    }

    String getPropertyName(String colName) {
        return this.map.get(colName.toLowerCase());
    }

    public CustomQuery<T> displayHeaders() {
        this.execute();
        for (ColumnMetadata md : this.rl.getColMD()) {
            int len = md.getMaxLen() > md.getColName().length() ? md.getMaxLen() : md.getColName().length();
            System.out.print(StringUtil.pad(md.getColName(), len, '*'));
            System.out.print(" | ");
        }
        System.out.println("");
        return this;
    }

    public void displayResults() {
        this.execute();
        for (Object t : this.rl) {
            this.rl.getColMD().forEach(md -> {
                Object v = null;
                if (t instanceof Record) {
                    v = ((Record)t).getValue(md.getColName());
                } else {
                    String pName = this.getPropertyName(md.getColName());
                    if (pName != null) {
                        try {
                            v = BeanUtils.getProperty(t, pName);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                int len = md.getMaxLen() > md.getColName().length() ? md.getMaxLen() : md.getColName().length();
                System.out.print(StringUtil.pad(v.toString(), len, ' '));
                System.out.print(" | ");
            });
            System.out.println("");
        }
    }
}

