/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.LocalDB;
import io.baltoro.obj.Base;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Linked<T extends Base> {
    private String srcUuid;
    private LocalDB.Direction direction;
    private int count;
    private List<String> uuids;
    private List<T> objs;
    private Map<String, Set<String>> attUuidMap;
    private Map<String, Set<Base>> attObjMap;
    private Class<T> c;
    private LocalDB db;

    Linked(Class<T> c, String srcUuid, LocalDB.Direction direction, LocalDB db) {
        this.c = c;
        this.db = db;
        this.srcUuid = srcUuid;
        this.direction = direction;
    }

    public List<String> getUuids() {
        return this.uuids;
    }

    void setUuids(List<String> uuids) {
        this.uuids = uuids;
    }

    public int getCount() {
        return this.count;
    }

    void setCount(int count) {
        this.count = count;
    }

    public List<T> getList() {
        return this.objs;
    }

    void setList(List<T> list) {
        this.objs = list;
    }

    public String getFirstUuid() {
        return this.uuids.get(0);
    }

    public T getFirst() {
        this.getAll();
        return (T)((Base)this.objs.get(0));
    }

    public List<T> getAll() {
        if (this.objs == null) {
            List<Base> objs = this.db.get(this.uuids);
            this.setList(objs);
        }
        return this.objs;
    }

    public T[] getAllAsArray() {
        this.getAll();
        Object[] arr = (Object[])Array.newInstance(this.c, this.objs.size());
        return (Base[])this.objs.toArray(arr);
    }

    public String[] getUuidsAsArray() {
        return this.uuids.toArray(new String[this.uuids.size()]);
    }

    public Class<T> getType() {
        return this.c;
    }

    public Set<String> getAttUuids(String objUuid) {
        if (this.attUuidMap == null) {
            this.attUuidMap = this.db.getLinkAtt(this.srcUuid, this.uuids, this.direction);
        }
        Set<String> set = this.attUuidMap.get(objUuid);
        return set;
    }
}

