/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.Baltoro;
import io.baltoro.to.APIError;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;

public class CheckResponseFilter
implements ClientResponseFilter {
    static Logger log = Logger.getLogger(CheckResponseFilter.class.getName());

    @Override
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        this.receiveCookies(responseContext);
        int status = responseContext.getStatus();
        Response.StatusType statusType = responseContext.getStatusInfo();
        String error = responseContext.getHeaderString("api-error");
        if (status == 455) {
            throw new APIError(error);
        }
    }

    void receiveCookies(ClientResponseContext context) {
        Map<String, NewCookie> map = context.getCookies();
        for (String key : map.keySet()) {
            NewCookie cookie = map.get(key);
            Baltoro.cookieMap.put(key, cookie);
        }
    }
}

