/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.Replicator;
import io.baltoro.to.ReplicationTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

class PreparedStatement {
    private java.sql.PreparedStatement stmt;
    List<ReplicationTO> repList = null;

    PreparedStatement(java.sql.PreparedStatement stmt) {
        this.stmt = stmt;
    }

    boolean executeAndReplicate(String ... att) throws SQLException {
        boolean x = this.stmt.execute();
        Replicator.push(this.stmt, att);
        return x;
    }

    boolean executeNoReplicate() throws SQLException {
        boolean x = this.stmt.execute();
        return x;
    }

    ResultSet executeQuery() throws SQLException {
        return this.stmt.executeQuery();
    }

    void close() throws SQLException {
        this.stmt.close();
    }

    void setString(int parameterIndex, String x) throws SQLException {
        this.stmt.setString(parameterIndex, x);
    }

    void setInt(int parameterIndex, int x) throws SQLException {
        this.stmt.setInt(parameterIndex, x);
    }

    void setLong(int parameterIndex, long x) throws SQLException {
        this.stmt.setLong(parameterIndex, x);
    }

    void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.stmt.setTimestamp(parameterIndex, x);
    }

    void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.stmt.setBytes(parameterIndex, x);
    }

    void addbatch(String ... att) throws SQLException {
        if (this.repList == null) {
            this.repList = new ArrayList<ReplicationTO>();
        }
        ReplicationTO repTO = Replicator.create(Replicator.getSQL(this.stmt), att);
        this.repList.add(repTO);
        this.stmt.addBatch();
    }

    void executeBatch() throws SQLException {
        HashSet<String> attSet = new HashSet<String>();
        StringBuffer sqls = new StringBuffer();
        StringBuffer attBuffer = new StringBuffer();
        for (ReplicationTO to : this.repList) {
            String[] item = to.att.split(" ");
            for (int i = 0; i < item.length; ++i) {
                attSet.add(item[i]);
            }
            sqls.append(to.cmd + "\n<BLT-BLT>\n");
        }
        attSet.stream().forEach(a -> attBuffer.append(a + " "));
        Replicator.pushBatch(sqls.toString(), attBuffer.toString());
        this.stmt.executeBatch();
        this.repList = null;
    }

    java.sql.PreparedStatement getStmt() {
        return this.stmt;
    }
}

