/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

class BaseColumnNode
extends ValueNode {
    private String columnName;
    private TableName tableName;

    BaseColumnNode(String string, TableName tableName, DataTypeDescriptor dataTypeDescriptor, ContextManager contextManager) throws StandardException {
        super(contextManager);
        this.columnName = string;
        this.tableName = tableName;
        this.setType(dataTypeDescriptor);
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    String getColumnName() {
        return this.columnName;
    }

    @Override
    String getTableName() {
        return this.tableName != null ? this.tableName.getTableName() : null;
    }

    @Override
    String getSchemaName() throws StandardException {
        return this.tableName != null ? this.tableName.getSchemaName() : null;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        throw StandardException.newException("42Z50", this.nodeHeader());
    }

    @Override
    protected int getOrderableVariantType() {
        return 1;
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) {
        if (this.isSameNodeKind(valueNode)) {
            BaseColumnNode baseColumnNode = (BaseColumnNode)valueNode;
            return baseColumnNode.tableName.equals(this.tableName) && baseColumnNode.columnName.equals(this.columnName);
        }
        return false;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.tableName != null) {
            this.tableName = (TableName)this.tableName.accept(visitor);
        }
    }
}

