/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.UserSession;
import io.baltoro.to.APIError;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;

public class CSResponseFilter
implements ClientResponseFilter {
    static Logger log = Logger.getLogger(CSResponseFilter.class.getName());
    private String appName;
    private UserSession session;

    public CSResponseFilter(String appName, UserSession session) {
        this.appName = appName;
        this.session = session;
    }

    @Override
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        this.receiveCookies(responseContext);
        int status = responseContext.getStatus();
        Response.StatusType statusType = responseContext.getStatusInfo();
        String error = responseContext.getHeaderString("api-error");
        if (status == 455) {
            throw new APIError(error);
        }
    }

    void receiveCookies(ClientResponseContext context) {
        Map<String, NewCookie> map = context.getCookies();
        for (String key : map.keySet()) {
            NewCookie cookie = map.get(key);
            log.info("received ======<" + this.appName + ">======= >>>[" + map.hashCode() + "]>> 111 >>>>>> " + key + " : " + cookie);
            if (this.session == null) continue;
            this.session.addCookie(cookie.getName(), cookie.getValue());
        }
    }
}

