/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.baltoro.client.Baltoro;
import io.baltoro.client.RequestWorker;
import io.baltoro.client.SessionManager;
import io.baltoro.client.WorkerPool;
import io.baltoro.client.util.StringUtil;
import io.baltoro.to.WSTO;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;

public class RequestPoller {
    private static RequestPoller poller;
    private ObjectMapper mapper = new ObjectMapper();
    private OperatingSystemMXBean os = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    private MemoryMXBean mem = ManagementFactory.getPlatformMXBean(MemoryMXBean.class);
    private Timer pollTimer;
    private Timer workerTimer;
    private ConcurrentLinkedQueue<String> q = new ConcurrentLinkedQueue();
    private String syncKey = "request-poll-worker";

    private RequestPoller() {
    }

    public static RequestPoller instance() {
        if (poller == null) {
            poller = new RequestPoller();
            poller.init();
        }
        return poller;
    }

    public void init() {
        this.pollTimer = new Timer();
        this.pollTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block6: {
                    System.out.println("############################### poll timer " + new Date());
                    int cpu = (int)RequestPoller.this.os.getSystemLoadAverage();
                    long maxMem = (int)RequestPoller.this.mem.getHeapMemoryUsage().getCommitted();
                    long usedMem = (int)RequestPoller.this.mem.getHeapMemoryUsage().getUsed();
                    int freeMem = (int)(maxMem - usedMem) / 1000000;
                    String json = null;
                    try {
                        json = Baltoro.cs.poll(cpu, freeMem);
                        if (!StringUtil.isNotNullAndNotEmpty(json)) break block6;
                        RequestPoller.this.q.add(json);
                        String string = RequestPoller.this.syncKey.intern();
                        synchronized (string) {
                            RequestPoller.this.syncKey.notify();
                        }
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof SocketTimeoutException) {
                            System.out.println("Read timeout, will try again ... " + e);
                        }
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
            }
        }, 0L, 1L);
        this.workerTimer = new Timer();
        this.workerTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WSTO[] tos;
                    System.out.println("############################### worker timer " + new Date());
                    String json = (String)RequestPoller.this.q.poll();
                    if (json == null) {
                        String string = RequestPoller.this.syncKey.intern();
                        synchronized (string) {
                            RequestPoller.this.syncKey.wait(10000L);
                            return;
                        }
                    }
                    for (WSTO wsto : tos = RequestPoller.this.mapper.readValue(json, WSTO[].class)) {
                        if (wsto.requestContext != null && wsto.requestContext.isInvalidateSession()) {
                            SessionManager.removeSession(wsto.requestContext.getSessionId());
                            continue;
                        }
                        RequestWorker worker = WorkerPool.getRequestWorker();
                        worker.set(wsto);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 0L, 1L);
    }
}

