/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.Baltoro;
import io.baltoro.client.UserSession;
import io.baltoro.to.APIError;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;

public class CSResponseFilter
implements ClientResponseFilter {
    static Logger log = Logger.getLogger(CSResponseFilter.class.getName());
    private String appName;

    public CSResponseFilter(String appName) {
        this.appName = appName;
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        this.receiveCookies(responseContext);
        int status = responseContext.getStatus();
        Response.StatusType statusType = responseContext.getStatusInfo();
        String error = responseContext.getHeaderString("api-error");
        if (status == 455) {
            throw new APIError(error);
        }
    }

    void receiveCookies(ClientResponseContext context) {
        UserSession userSession = Baltoro.getUserSession();
        Map map = context.getCookies();
        for (String key : map.keySet()) {
            NewCookie cookie = (NewCookie)map.get(key);
            userSession.addCookie(cookie.getName(), cookie.getValue());
        }
    }
}

