/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.Baltoro;
import io.baltoro.to.SessionUserTO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.NewCookie;

public class UserSession {
    private final String sessionId;
    Map<String, String> attMap = new HashMap<String, String>(200);
    private Set<String> roles = new HashSet<String>();
    private String userName;
    private boolean authenticated;
    private long createdOn;
    private long authenticatedOn;
    private int timeoutMin = 20;
    private Map<String, Set<NewCookie>> cookieAppMap = new HashMap<String, Set<NewCookie>>(100);

    UserSession(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getAttribute(String name) {
        return this.attMap.get(name);
    }

    public void addAttribute(String name, String value) {
        this.attMap.put(name, value);
        this.sendSession();
    }

    public void addRoles(String roleName) {
        this.roles.add(roleName);
        this.sendSession();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUserName() {
        return this.userName;
    }

    void setUserName(String userName) {
        this.userName = userName;
    }

    boolean isAuthenticated() {
        return this.authenticated;
    }

    void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
        this.authenticatedOn = System.currentTimeMillis();
    }

    public long getCreatedOn() {
        return this.createdOn;
    }

    void setCreatedOn(long createdOn) {
        this.createdOn = createdOn;
    }

    public int getTimeoutMin() {
        return this.timeoutMin;
    }

    void setTimeoutMin(int timeoutMin) {
        this.timeoutMin = timeoutMin;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    void addCookie(String name, String value) {
        Set<NewCookie> cookieSet = this.cookieAppMap.get(Baltoro.appName);
        if (cookieSet == null) {
            cookieSet = new HashSet<NewCookie>(100);
            this.cookieAppMap.put(Baltoro.appName, cookieSet);
        }
        NewCookie cookie = new NewCookie(name, value);
        cookieSet.add(cookie);
    }

    Set<NewCookie> getCookies() {
        Set<NewCookie> cookieSet = this.cookieAppMap.get(Baltoro.appName);
        if (cookieSet == null) {
            cookieSet = new HashSet<NewCookie>(100);
            this.cookieAppMap.put(Baltoro.appName, cookieSet);
        }
        cookieSet.add(new NewCookie("BLT_SESSION_ID", this.sessionId));
        return cookieSet;
    }

    void sendSession() {
        SessionUserTO to = new SessionUserTO();
        to.sessionUuid = this.getSessionId();
        to.userName = this.getUserName();
        to.authenticated = this.authenticated;
        to.roles = this.roles;
        to.att = this.attMap;
        to.createdOn = this.createdOn;
        to.authenticatedOn = this.authenticatedOn;
        to.timeoutMin = this.timeoutMin;
        try {
            if (this.isAuthenticated()) {
                Baltoro.cs.validateSession(this.getSessionId(), to);
            } else {
                Baltoro.cs.inValidateSession(this.getSessionId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

