/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.UnaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class IsNullNode
extends UnaryComparisonOperatorNode
implements RelationalOperator {
    private DataValueDescriptor nullValue;
    private boolean notNull;

    IsNullNode(ValueNode valueNode, boolean bl, ContextManager contextManager) throws StandardException {
        super(valueNode, contextManager);
        this.notNull = bl;
        this.updateOperatorDetails();
    }

    private void updateOperatorDetails() {
        this.setOperator(this.notNull ? "is not null" : "is null");
        this.setMethodName(this.notNull ? "isNotNull" : "isNullOp");
    }

    @Override
    UnaryOperatorNode getNegation(ValueNode valueNode) throws StandardException {
        this.notNull = !this.notNull;
        this.updateOperatorDetails();
        return this;
    }

    @Override
    void bindParameter() throws StandardException {
        this.operand.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
    }

    @Override
    public boolean usefulStartKey(Optimizable optimizable) {
        return this.isNullNode();
    }

    @Override
    public boolean usefulStopKey(Optimizable optimizable) {
        return this.isNullNode();
    }

    @Override
    public int getStartOperator(Optimizable optimizable) {
        return 1;
    }

    @Override
    public int getStopOperator(Optimizable optimizable) {
        return -1;
    }

    @Override
    public void generateOperator(MethodBuilder methodBuilder, Optimizable optimizable) {
        methodBuilder.push(2);
    }

    @Override
    public void generateNegate(MethodBuilder methodBuilder, Optimizable optimizable) {
        methodBuilder.push(this.notNull);
    }

    @Override
    public int getOperator() {
        return this.notNull ? 8 : 7;
    }

    @Override
    public boolean compareWithKnownConstant(Optimizable optimizable, boolean bl) {
        return true;
    }

    @Override
    public DataValueDescriptor getCompareValue(Optimizable optimizable) throws StandardException {
        if (this.nullValue == null) {
            this.nullValue = this.operand.getTypeServices().getNull();
        }
        return this.nullValue;
    }

    @Override
    public boolean equalsComparisonWithConstantExpression(Optimizable optimizable) {
        if (this.notNull) {
            return false;
        }
        boolean bl = false;
        if (this.operand instanceof ColumnReference) {
            int n = ((ColumnReference)this.operand).getTableNumber();
            if (optimizable.hasTableNumber() && optimizable.getTableNumber() == n) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public RelationalOperator getTransitiveSearchClause(ColumnReference columnReference) throws StandardException {
        return new IsNullNode(columnReference, this.notNull, this.getContextManager());
    }

    @Override
    String getReceiverInterfaceName() {
        return "org.apache.derby.iapi.types.DataValueDescriptor";
    }

    @Override
    public double selectivity(Optimizable optimizable) {
        if (this.notNull) {
            return 0.9;
        }
        return 0.1;
    }

    boolean isNullNode() {
        return !this.notNull;
    }

    @Override
    boolean isRelationalOperator() {
        return true;
    }

    @Override
    boolean optimizableEqualityNode(Optimizable optimizable, int n, boolean bl) {
        if (!this.isNullNode() || !bl) {
            return false;
        }
        ColumnReference columnReference = this.getColumnOperand(optimizable, n);
        return columnReference != null;
    }
}

