/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.baltoro.client.WebMethod;
import io.baltoro.client.WebMethodMap;
import io.baltoro.client.util.StringUtil;
import io.baltoro.features.AbstractFilter;
import io.baltoro.features.Filter;
import io.baltoro.features.NoAuth;
import io.baltoro.features.NoDiscover;
import io.baltoro.features.Param;
import io.baltoro.features.Path;
import io.baltoro.features.Timeout;
import io.baltoro.features.WS;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.security.RolesAllowed;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class AnnotationProcessor {
    static Logger log = Logger.getLogger(AnnotationProcessor.class.getName());
    Map<String, WebMethod> pathMap = new HashMap<String, WebMethod>(100);
    static ObjectMapper mapper = new ObjectMapper();

    public Map<String, WebMethod> processAnnotation(String serviceName, String packageName) throws Exception {
        log.info("serviceName = " + serviceName + ", packageName = " + packageName);
        Set<Class<?>> classes = AnnotationProcessor.getClasses(packageName);
        for (Method[] methodArray : classes) {
            Annotation[] annoArray;
            log.info("class = " + methodArray);
            for (Annotation anno : annoArray = methodArray.getAnnotations()) {
                if (anno instanceof Filter) {
                    Filter filterAnno = (Filter)anno;
                    Method[] filter = methodArray;
                    WebMethodMap.getInstance().addFilter(filterAnno.value(), (Class<AbstractFilter>)filter);
                }
                String cPath = null;
                if (anno instanceof Path) {
                    cPath = ((Path)anno).value();
                }
                if (anno instanceof WS) {
                    cPath = ((WS)anno).value();
                }
                if (cPath == null) continue;
                for (Method method : methodArray.getDeclaredMethods()) {
                    Timeout timeoutAnno;
                    WebMethod wm = this.processPathAnno(serviceName, method, (Class<?>)methodArray, cPath);
                    if (wm == null || (timeoutAnno = method.getAnnotation(Timeout.class)) == null) continue;
                    wm.timeoutSec = timeoutAnno.value();
                }
                if (!(anno instanceof RolesAllowed)) continue;
                RolesAllowed roleAnno = (RolesAllowed)anno;
                String[] roles = roleAnno.value();
                for (int i = 0; i < roles.length; ++i) {
                    System.out.println("role allowed" + roles[i]);
                }
            }
        }
        for (String string : this.pathMap.keySet()) {
            System.out.println("PATH -> " + string + " --> " + this.pathMap.get(string));
        }
        return this.pathMap;
    }

    private WebMethod processPathAnno(String serviceName, Method method, Class<?> _class, String cPath) {
        WebMethod wm = null;
        boolean cNoAuth = _class.isAnnotationPresent(NoAuth.class);
        boolean cNoDiscover = _class.isAnnotationPresent(NoDiscover.class);
        boolean isWS = false;
        String fPath = null;
        if (method.isAnnotationPresent(Path.class)) {
            Path pathAnno = method.getAnnotation(Path.class);
            String mPath = pathAnno.value();
            if (!mPath.startsWith("/")) {
                mPath = "/" + mPath;
            }
            fPath = cPath.equals("/") ? mPath : cPath + mPath;
            fPath = StringUtil.isNullOrEmpty(serviceName) || serviceName.equals("/") ? fPath.toLowerCase() : "/" + serviceName + fPath.toLowerCase();
        }
        if (method.isAnnotationPresent(OnOpen.class)) {
            fPath = cPath + "/onopen";
            isWS = true;
        }
        if (method.isAnnotationPresent(OnClose.class)) {
            fPath = cPath + "/onclose";
            isWS = true;
        }
        if (method.isAnnotationPresent(OnMessage.class)) {
            fPath = cPath + "/onmessage";
            isWS = true;
        }
        if (fPath == null) {
            return null;
        }
        wm = new WebMethod(fPath, _class, method);
        wm.setWebSocket(isWS);
        if (cNoAuth) {
            wm.authRequired = false;
        } else {
            boolean bl = wm.authRequired = !method.isAnnotationPresent(NoAuth.class);
        }
        wm.discoverable = cNoDiscover ? false : !method.isAnnotationPresent(NoDiscover.class);
        this.pathMap.put(fPath, wm);
        StringBuilder mPropsJson = new StringBuilder();
        mPropsJson.append("{");
        Class<?> returnType = method.getReturnType();
        String rType = returnType == null ? "void" : returnType.getSimpleName();
        mPropsJson.append("\"output\":\"" + rType + "\",");
        if (returnType != null && !returnType.isPrimitive()) {
            Field[] fields = returnType.getFields();
            for (int i = 0; i < fields.length; ++i) {
            }
        }
        Parameter[] methodParms = method.getParameters();
        mPropsJson.append("\"input\":{");
        boolean inputFound = false;
        for (int i = 0; i < methodParms.length; ++i) {
            Parameter param = methodParms[i];
            Class<?> paramClass = param.getType();
            String annoName = null;
            Annotation[] annos = param.getAnnotations();
            for (int j = 0; j < annos.length; ++j) {
                Annotation paramAnno = annos[j];
                if (paramAnno.annotationType() != Param.class) continue;
                Param annoPraram = (Param)paramAnno;
                annoName = annoPraram.value();
                inputFound = true;
                mPropsJson.append("\"param\":{");
                mPropsJson.append("\"parma-name\":\"" + annoName + "\",");
                mPropsJson.append("\"data-type\":\"" + paramClass.getSimpleName() + "\"");
                mPropsJson.append("},");
            }
        }
        if (inputFound) {
            mPropsJson.delete(mPropsJson.length() - 1, mPropsJson.length());
        }
        mPropsJson.append("}");
        mPropsJson.append('}');
        wm.propJson = mPropsJson.toString();
        return wm;
    }

    static Set<Class<?>> getClasses(String packageName) throws Exception {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        HashSet masterClassSet = new HashSet();
        Set<Class<?>> set = reflections.getTypesAnnotatedWith(Path.class);
        masterClassSet.addAll(set);
        set = reflections.getTypesAnnotatedWith(Filter.class);
        masterClassSet.addAll(set);
        set = reflections.getTypesAnnotatedWith(WS.class);
        masterClassSet.addAll(set);
        return masterClassSet;
    }
}

