/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.baltoro.client.Baltoro;
import io.baltoro.client.ResponseQueue;
import io.baltoro.client.SendRedirect;
import io.baltoro.client.SessionManager;
import io.baltoro.client.UserSession;
import io.baltoro.client.WebMethod;
import io.baltoro.client.WebMethodMap;
import io.baltoro.client.WorkerPool;
import io.baltoro.client.util.StringUtil;
import io.baltoro.exp.AuthException;
import io.baltoro.features.AbstractFilter;
import io.baltoro.features.Param;
import io.baltoro.to.APIError;
import io.baltoro.to.RequestContext;
import io.baltoro.to.ResponseContext;
import io.baltoro.to.SessionUserTO;
import io.baltoro.to.WSTO;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestWorker
extends Thread {
    private WSTO to;
    UserSession userSession;
    List<AbstractFilter> filters = new ArrayList<AbstractFilter>();
    static ObjectMapper mapper = new ObjectMapper();
    boolean run = true;
    static int _count;
    int count;
    long lastWorked = System.currentTimeMillis();

    RequestWorker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(WSTO to) {
        this.to = to;
        RequestWorker requestWorker = this;
        synchronized (requestWorker) {
            this.notify();
        }
    }

    void clear() {
        this.to = null;
        this.userSession = null;
        this.filters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.run) {
            if (this.to == null) {
                RequestWorker requestWorker = this;
                synchronized (requestWorker) {
                    try {
                        this.wait(10000L);
                        if (this.to == null) {
                            continue;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                this.work();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.lastWorked = System.currentTimeMillis();
                this.to = null;
                WorkerPool.done(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work() {
        if (this.to == null) {
            System.out.println("ERROR PARSING WSTO !!!!!!! CHECK ");
            return;
        }
        RequestContext req = this.to.requestContext;
        ResponseContext res = new ResponseContext();
        res.setHeaders(new HashMap<String, String>());
        this.to.responseContext = res;
        res.setSessionId(req.getSessionId());
        Baltoro.userSessionIdCtx.set(req.getSessionId());
        Baltoro.serviceNameCtx.set(this.to.serviceName);
        Baltoro.userRequestCtx.set(req);
        Baltoro.userResponseCtx.set(res);
        try {
            this.process();
        }
        catch (Exception e) {
            if (e instanceof SendRedirect) {
                SendRedirect sd = (SendRedirect)e;
                res.setRedirect(sd.getUrl());
            } else if (e.getCause() instanceof SendRedirect) {
                SendRedirect sd = (SendRedirect)e.getCause();
                res.setRedirect(sd.getUrl());
            } else if (e instanceof APIError) {
                APIError er = (APIError)e;
                res.setError(er.getMessage());
            } else if (e.getCause() instanceof APIError) {
                APIError er = (APIError)e.getCause();
                res.setRedirect(er.getMessage());
            } else if (e instanceof AuthException) {
                res.setError(e.getMessage());
            } else {
                e.printStackTrace();
                res.setError(e.getMessage() + "---" + (e.getCause() != null ? e.getCause().getMessage() : ""));
            }
        }
        finally {
            ResponseQueue.instance().addToResponseQueue(this.to);
            Baltoro.userSessionIdCtx.set(null);
            Baltoro.serviceNameCtx.set(null);
            Baltoro.userRequestCtx.set(null);
            Baltoro.userResponseCtx.set(null);
        }
    }

    private void process() throws Exception {
        RequestContext req = this.to.requestContext;
        ResponseContext res = this.to.responseContext;
        if (StringUtil.isNotNullAndNotEmpty(req.getSessionId())) {
            SessionUserTO to;
            long tc;
            long t0;
            long dif;
            String reqSessionId = req.getSessionId();
            this.userSession = SessionManager.getSession(reqSessionId);
            if (!this.userSession.isAuthenticated() && (dif = (t0 = System.currentTimeMillis()) - (tc = this.userSession.getCreatedOn())) > 59000L && (to = Baltoro.cs.pullSession(reqSessionId)) != null) {
                this.userSession = SessionManager.getSession(reqSessionId);
                this.userSession.setRoles(to.roles);
                this.userSession.attMap = to.att;
                this.userSession.setUserName(to.userName);
                this.userSession.setAuthenticated(to.authenticated);
            }
        }
        List<String> filterNames = WebMethodMap.getInstance().getFilterNames();
        for (String fNames : filterNames) {
            Class<AbstractFilter> _class = WebMethodMap.getInstance().getFilterClass(fNames);
            try {
                AbstractFilter filter = _class.newInstance();
                this.filters.add(filter);
                filter.before(this.to, this.userSession);
            }
            catch (Exception e) {
                if (e instanceof SendRedirect) {
                    SendRedirect sd = (SendRedirect)e;
                    res.setRedirect(sd.getUrl());
                    return;
                }
                if (e.getCause() instanceof SendRedirect) {
                    SendRedirect sd = (SendRedirect)e.getCause();
                    res.setRedirect(sd.getUrl());
                    return;
                }
                if (e instanceof AuthException) {
                    res.setError(e.getMessage());
                    return;
                }
                e.printStackTrace();
            }
        }
        String url = req.getApiPath();
        WebMethod wm = WebMethodMap.getInstance().getMethod(url);
        if (wm == null) {
            String path = req.getApiPath();
            String[] tokens = path.split("/");
            for (int i = 0; i < tokens.length; ++i) {
                int lIndex = path.lastIndexOf(47);
                if (lIndex == -1) {
                    System.out.println("no index found / error path=" + path);
                }
                try {
                    path = path.substring(0, lIndex);
                }
                catch (StringIndexOutOfBoundsException e) {
                    String error = "Can't find API path[" + url + ", " + path + "] on hostid=" + Baltoro.hostId + ", serviceNames=" + Baltoro.serviceNames.toString();
                    System.out.println(error);
                    e.printStackTrace();
                    throw new Exception(error);
                }
                String lPath = req.getApiPath().substring(lIndex + 1);
                wm = WebMethodMap.getInstance().getMethod(path + "/*");
                if (wm == null) continue;
                req.setRelativePath(lPath);
                break;
            }
        }
        if (wm == null) {
            res.setError("API for path [" + req.getApiPath() + "] not found ");
        }
        try {
            this.checkAuth(wm, this.to, wm.getWebPath());
            Object returnObj = this.executeMethod(wm, this.to);
            for (AbstractFilter filter : this.filters) {
                filter.after(returnObj, this.to, this.userSession);
            }
            if (returnObj != null) {
                this.to.responseContext.setReturnObject(returnObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void checkAuth(WebMethod wm, WSTO to, String path) throws AuthException {
        if (!wm.authRequired) {
            return;
        }
        String sessionId = to.requestContext.getSessionId();
        if (sessionId == null) {
            throw new AuthException("Authentiction required for " + path);
        }
        UserSession userSession = Baltoro.getUserSession();
        if (userSession == null) {
            throw new AuthException("Authentiction required for " + path);
        }
        if (!userSession.isAuthenticated()) {
            throw new AuthException("Authentiction required for " + path);
        }
    }

    private Object executeMethod(WebMethod wMethod, WSTO to) throws Exception {
        Map<String, String[]> requestParam;
        RequestContext reqCtx = to.requestContext;
        ResponseContext resCtx = to.responseContext;
        Map<String, String[]> map = requestParam = reqCtx == null ? null : reqCtx.getRequestParams();
        if (requestParam == null || requestParam.size() == 0) {
            requestParam = new HashMap<String, String[]>();
        }
        Class<?> _class = wMethod.get_class();
        Method method = wMethod.getMethod();
        Parameter[] methodParms = method.getParameters();
        Object[] methodInputData = new Object[methodParms.length];
        for (int i = 0; i < methodParms.length; ++i) {
            Parameter param = methodParms[i];
            Class<?> paramClass = param.getType();
            String annoName = null;
            Annotation[] annos = param.getAnnotations();
            for (int j = 0; j < annos.length; ++j) {
                Annotation anno = annos[j];
                if (anno.annotationType() != Param.class) continue;
                Param annoPraram = (Param)anno;
                annoName = annoPraram.value();
                break;
            }
            String[] requestValue = requestParam.get(annoName);
            if (annoName != null && requestValue == null) {
                StringBuffer buffer = new StringBuffer();
                for (String paramName : requestParam.keySet()) {
                    buffer.append(paramName + ",");
                }
                throw new Exception(annoName + " is not submitted as a parameter. incoming params [" + buffer.toString() + "] ");
            }
            if (annoName != null) {
                if (paramClass == String.class && requestValue != null) {
                    methodInputData[i] = requestValue[0];
                    continue;
                }
                if (paramClass == String[].class && requestValue != null) {
                    methodInputData[i] = requestValue;
                    continue;
                }
                methodInputData[i] = mapper.readValue(requestValue[0], paramClass);
                continue;
            }
            if (paramClass == RequestContext.class) {
                methodInputData[i] = reqCtx;
                continue;
            }
            if (paramClass == ResponseContext.class) {
                methodInputData[i] = resCtx;
                continue;
            }
            if (paramClass != UserSession.class) continue;
            methodInputData[i] = this.userSession;
        }
        Object classInstance = null;
        if (!wMethod.isWebSocket()) {
            classInstance = _class.newInstance();
        }
        if (classInstance == null) {
            System.out.println("classInstance is null why ?  - " + _class);
            return null;
        }
        Object returnObj = method.invoke(classInstance, methodInputData);
        return returnObj;
    }
}

