/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.ep;

import io.baltoro.ep.BytesClassLoader;
import io.baltoro.ep.EPFileManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

final class EPCompiler {
    private JavaCompiler tool = ToolProvider.getSystemJavaCompiler();
    private StandardJavaFileManager stdManager;

    public EPCompiler() {
        if (this.tool == null) {
            throw new RuntimeException("Could not get Java compiler. Please, ensure that JDK is used instead of JRE.");
        }
        this.stdManager = this.tool.getStandardFileManager(null, null, null);
    }

    public Class<?> compileClass(String packageName, String className, String source) throws ClassNotFoundException {
        Map<String, byte[]> classBytes = this.compile(className + ".java", source);
        byte[] bytes = classBytes.get(packageName + "." + className);
        for (String key : classBytes.keySet()) {
            System.err.println("key ===> " + key + ", " + className);
        }
        System.out.println(bytes.length);
        BytesClassLoader classLoader = new BytesClassLoader();
        Class<?> clazz = classLoader.loadThisClass(packageName + "." + className, bytes);
        System.out.println("class -- " + clazz);
        return clazz;
    }

    private Map<String, byte[]> compile(String fileName, String source) {
        return this.compile(fileName, source, (Writer)new PrintWriter(System.err), null, null);
    }

    private Map<String, byte[]> compile(String fileName, String source, Writer err, String sourcePath, String classPath) {
        EPFileManager fileManager = new EPFileManager(this.stdManager);
        ArrayList<JavaFileObject> compUnits = new ArrayList<JavaFileObject>(1);
        compUnits.add(EPFileManager.makeStringSource(fileName, source));
        return this.compile(compUnits, fileManager, err, sourcePath, classPath);
    }

    private Map<String, byte[]> compile(List<JavaFileObject> compUnits, EPFileManager fileManager, Writer err, String sourcePath, String classPath) {
        JavaCompiler.CompilationTask task;
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ArrayList<String> options = new ArrayList<String>();
        options.add("-Xlint:all");
        options.add("-deprecation");
        if (sourcePath != null) {
            options.add("-sourcepath");
            options.add(sourcePath);
        }
        if (classPath != null) {
            options.add("-classpath");
            options.add(classPath);
        }
        if (!(task = this.tool.getTask(err, fileManager, diagnostics, options, null, compUnits)).call().booleanValue()) {
            PrintWriter perr = new PrintWriter(err);
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                perr.println(diagnostic);
            }
            perr.flush();
            return null;
        }
        Map<String, byte[]> classBytes = fileManager.getClassBytes();
        try {
            fileManager.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return classBytes;
    }
}

