/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.ep;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.baltoro.client.Baltoro;
import io.baltoro.client.CSRequestFilter;
import io.baltoro.client.CSResponseFilter;
import io.baltoro.client.util.ObjectUtil;
import io.baltoro.client.util.StringUtil;
import io.baltoro.ep.EPData;
import io.baltoro.to.APIError;
import io.baltoro.to.RequestContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.jackson.JacksonFeature;

public class CloudServer {
    static ExecutorService executor = Executors.newWorkStealingPool();
    static Logger log = Logger.getLogger(CloudServer.class.getName());
    static ObjectMapper mapper = new ObjectMapper();
    Client client;
    static Map<String, Map<String, NewCookie>> cookieMap = new HashMap<String, Map<String, NewCookie>>();
    static Map<String, Client> cientMap = new HashMap<String, Client>();
    String appName;
    boolean online = false;

    public CloudServer(String appName, RequestContext req) {
        this.appName = appName;
        Map<String, NewCookie> cMap = cookieMap.get(appName);
        if (cMap == null) {
            cMap = new HashMap<String, NewCookie>(50);
            cookieMap.put(appName, cMap);
        }
        cMap.put("BLT_SESSION_ID", new NewCookie("BLT_SESSION_ID", req.getSessionId()));
        CSResponseFilter responseFilter = new CSResponseFilter(cMap);
        CSRequestFilter requestFilter = new CSRequestFilter(cMap);
        this.client = cientMap.get(appName);
        if (this.client == null) {
            this.client = ((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).register((Object)requestFilter)).register((Object)responseFilter)).build();
            cientMap.put(appName, this.client);
        }
    }

    Invocation.Builder getIB(WebTarget target) {
        Invocation.Builder ib = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        Map<String, NewCookie> map = cookieMap.get(this.appName);
        Set<String> cookieNames = map.keySet();
        StringBuffer buffer = new StringBuffer();
        for (String cookieName : cookieNames) {
            NewCookie cookie = map.get(cookieName);
            String _cookie = cookie.getName() + "=" + cookie.getValue() + ";";
            buffer.append(_cookie);
        }
        ib.header("Cookie", (Object)buffer.toString());
        return ib;
    }

    public <T> T execute(String path, EPData data, Class<T> returnType, Class<?> returnSubType) {
        WebTarget target = this.client.target(Baltoro.getServerUrl()).path(path);
        log.info("url --> " + target);
        Form form = new Form();
        List<Object[]> list = data.list;
        for (Object[] objects : list) {
            String name = (String)objects[0];
            String value = (String)objects[1];
            form.param(name, value);
        }
        Invocation.Builder ib = this.getIB(target);
        Response response = ib.post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        String error = response.getHeaderString("BALTORO-ERROR");
        if (StringUtil.isNotNullAndNotEmpty(error)) {
            System.out.println("////////////////////////");
            System.out.println(error);
            System.out.println("////////////////////////");
            throw new APIError(error);
        }
        String json = (String)response.readEntity(String.class);
        if (returnSubType != null) {
            Object obj = ObjectUtil.toObject(returnSubType, json.getBytes());
            return returnType.cast(obj);
        }
        Object obj = ObjectUtil.toObject(returnType, json.getBytes());
        return returnType.cast(obj);
    }

    public <T> T call(String path, EPData data, Class<T> returnType) {
        Invocation.Builder ib;
        Response response;
        String error;
        WebTarget target = this.client.target(Baltoro.getServerUrl()).path(path);
        log.info("url --> " + target);
        Form form = new Form();
        if (data != null) {
            List<Object[]> list = data.list;
            for (Object[] objects : list) {
                String name = (String)objects[0];
                String value = (String)objects[1];
                form.param(name, value);
            }
        }
        if (StringUtil.isNotNullAndNotEmpty(error = (response = (ib = this.getIB(target)).post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE))).getHeaderString("BALTORO-ERROR"))) {
            System.out.println("////////////////////////");
            System.out.println(error);
            System.out.println("////////////////////////");
            throw new APIError(error);
        }
        String json = (String)response.readEntity(String.class);
        if (returnType == String.class) {
            return returnType.cast(json);
        }
        Object obj = ObjectUtil.toObject(returnType, json.getBytes());
        return returnType.cast(obj);
    }

    public Future<?> callAsyn(String path, EPData data, Class<?> returnType) {
        WebTarget target = this.client.target(Baltoro.getServerUrl()).path(path);
        log.info("url --> " + target);
        Form form = new Form();
        if (data != null) {
            List<Object[]> list = data.list;
            for (Object[] objects : list) {
                String name = (String)objects[0];
                String value = (String)objects[1];
                form.param(name, value);
            }
        }
        Invocation.Builder ib = this.getIB(target);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Object> future = executor.submit(() -> {
            Response response = ib.post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            String error = response.getHeaderString("BALTORO-ERROR");
            if (StringUtil.isNotNullAndNotEmpty(error)) {
                System.out.println("////////////////////////");
                System.out.println(error);
                System.out.println("////////////////////////");
                return error;
            }
            String json = (String)response.readEntity(String.class);
            if (returnType == String.class) {
                return returnType.cast(json);
            }
            Object obj = ObjectUtil.toObject(returnType, json.getBytes());
            return returnType.cast(obj);
        });
        return future;
    }

    public Response execute(Form form, WebTarget target) {
        Callable<Response> apiCall = () -> {
            Invocation.Builder ib = this.getIB(target);
            Response response = ib.post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            return response;
        };
        Future<Response> future = executor.submit(apiCall);
        return null;
    }
}

