/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.APIClient;
import io.baltoro.client.AnnotationProcessor;
import io.baltoro.client.Env;
import io.baltoro.client.LocalDB;
import io.baltoro.client.RequestPoller;
import io.baltoro.client.ResponsePoller;
import io.baltoro.client.ServicePackage;
import io.baltoro.client.SessionManager;
import io.baltoro.client.UserSession;
import io.baltoro.client.WebMethod;
import io.baltoro.client.WebMethodMap;
import io.baltoro.client.util.StringUtil;
import io.baltoro.ep.ClassBuilder;
import io.baltoro.ep.CloudServer;
import io.baltoro.ep.EPData;
import io.baltoro.ep.ParamInput;
import io.baltoro.to.RequestContext;
import io.baltoro.to.ResponseContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.ws.rs.core.NewCookie;

public class Baltoro {
    static Logger log = Logger.getLogger(Baltoro.class.getName());
    static ThreadLocal<String> userSessionIdCtx;
    static ThreadLocal<RequestContext> userRequestCtx;
    static ThreadLocal<ResponseContext> userResponseCtx;
    static ThreadLocal<String> serviceNameCtx;
    static Map<String, Class<?>> pathClassMap;
    static Map<String, NewCookie> agentCookieMap;
    static List<ServicePackage> serviceList;
    static StringBuffer serviceNames;
    static String hostId;
    static APIClient cs;
    static String instanceUuid;
    static int instanceThreadCount;
    static Properties props;
    static String appUuid;
    static String appPrivateKey;
    static String appName;
    static String userUuid;
    static File propFile;
    static String serverURL;
    static Env env;
    static String serverDomain;
    static int serverPort;
    static String serverProtocol;
    static String pullReplicationServiceNames;
    static ResponsePoller responsePoller;
    private static boolean running;
    static LocalDB db;
    static String lcp;
    static long repMillis;

    private static void buildService() throws Exception {
        HashMap<String, WebMethod> pathMap = new HashMap<String, WebMethod>(200);
        AnnotationProcessor p = new AnnotationProcessor();
        for (ServicePackage sp : serviceList) {
            for (String _package : sp.packageNames) {
                Map<String, WebMethod> pMap = p.processAnnotation(sp.serviceName, _package);
                pathMap.putAll(pMap);
            }
            WebMethodMap.getInstance().setMap(pathMap);
        }
    }

    public static LocalDB getDB() {
        if (!running) {
            System.out.println("Baltoro not running, first call Baltoro.start() method ... ");
            System.out.println("Shutting down ... ");
            System.exit(1);
        }
        return LocalDB.instance();
    }

    public static String getMainClassName() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        StackTraceElement ste = stElements[stElements.length - 1];
        return ste.getClassName();
    }

    public static Env getEnv() {
        return env;
    }

    public static String getMainClassPackageName() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        StackTraceElement ste = stElements[stElements.length - 1];
        String className = ste.getClassName();
        System.out.println(" ---- > " + className);
        String[] packs = className.split("\\.");
        if (packs.length > 1) {
            return packs[0] + "." + packs[1];
        }
        return packs[0];
    }

    public static <T> T endPointFactory(Class<T> _class) {
        try {
            Class<?> implClass = pathClassMap.get(_class.getName());
            if (implClass == null) {
                ClassBuilder builder = new ClassBuilder(_class);
                implClass = builder.buildClass();
                pathClassMap.put(_class.getName(), implClass);
            }
            Object obj = implClass.newInstance();
            return _class.cast(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T callSync(String path, Class<T> returnType, ParamInput input) {
        return Baltoro.callSync(appName, userRequestCtx.get(), path, returnType, input);
    }

    public static <T> T callSync(String path, Class<T> returnType) {
        return Baltoro.callSync(appName, userRequestCtx.get(), path, returnType, null);
    }

    private static <T> T callSync(String appName, RequestContext req, String path, Class<T> returnType, ParamInput input) {
        try {
            CloudServer cServer = new CloudServer(appName, req);
            EPData epData = null;
            if (input != null) {
                epData = input.getEPData();
            }
            T t = cServer.call(path, epData, returnType);
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Future<?> callAsync(String path, Class<?> returnType, ParamInput input) {
        return Baltoro.callAsync(appName, userRequestCtx.get(), path, returnType, input);
    }

    public static Future<?> callAsync(String path, Class<?> returnType) {
        return Baltoro.callAsync(appName, userRequestCtx.get(), path, returnType, null);
    }

    public static Future<?> callAsync(String appName, RequestContext req, String path, Class<?> returnType, ParamInput input) {
        try {
            CloudServer cServer = new CloudServer(appName, req);
            EPData epData = null;
            if (input != null) {
                epData = input.getEPData();
            }
            Future<?> f = cServer.callAsyn(path, epData, returnType);
            return f;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void validateSession(String userName, Set<String> roleNames, int sessionTimeoutMin) {
        String userSessionId = userSessionIdCtx.get();
        if (userSessionId == null) {
            return;
        }
        UserSession userSession = SessionManager.getSession(userSessionId);
        userSession.setUserName(userName);
        userSession.setAuthenticated(true);
        userSession.setRoles(roleNames);
        userSession.setTimeoutMin(sessionTimeoutMin);
        userSession.sendSession();
    }

    public static UserSession getUserSession() {
        String userSessionId = userSessionIdCtx.get();
        if (userSessionId == null) {
            return null;
        }
        UserSession userSession = SessionManager.getSession(userSessionId);
        return userSession;
    }

    public static void invalidateSession() {
        String userSessionId = userSessionIdCtx.get();
        if (userSessionId == null) {
            return;
        }
        UserSession userSession = SessionManager.getSession(userSessionId);
        userSession.setUserName(null);
        userSession.setAuthenticated(false);
        userSession.setRoles(null);
        userSession.attMap = null;
        SessionManager.removeSession(userSessionId);
        userSession.sendSession();
    }

    public static void init(String appName) {
        Baltoro.init(appName, null);
    }

    public static String getServerUrl() {
        return serverURL;
    }

    public static void init(String appName, Env env) {
        String _envStr = System.getProperties().getProperty("env");
        if (StringUtil.isNotNullAndNotEmpty(_envStr)) {
            Env _env = null;
            try {
                _env = Env.valueOf(_envStr.toUpperCase());
            }
            catch (Exception e) {
                System.out.println("Check JVM argument -Denv=? ALLOWED env values are " + Arrays.toString((Object[])Env.values()));
                System.out.println("shut down ...");
                System.exit(1);
            }
            Baltoro.env = _env;
        } else {
            Baltoro.env = env;
        }
        if (env == null) {
            env = Env.PRD;
        }
        Baltoro.appName = appName;
        switch (env) {
            case PRD: {
                Baltoro.appName = appName;
                serverURL = serverProtocol + "://" + Baltoro.appName + "." + serverDomain + ":" + serverPort;
                break;
            }
            case STG: {
                Baltoro.appName = appName + "-envsg";
                serverURL = serverProtocol + "://" + Baltoro.appName + "." + serverDomain + ":" + serverPort;
                break;
            }
            case QA: {
                Baltoro.appName = appName + "-envqa";
                serverURL = serverProtocol + "://" + Baltoro.appName + "." + serverDomain + ":" + serverPort;
                break;
            }
            case DEV: {
                Baltoro.appName = appName + "-envdv";
                serverURL = serverProtocol + "://" + Baltoro.appName + "." + serverDomain + ":" + serverPort;
                break;
            }
            case LOC: {
                serverURL = "http://localhost:8080";
                break;
            }
            default: {
                serverURL = serverProtocol + "://www.baltoro.io";
            }
        }
    }

    public static void register(String serviceName, String ... packageNames) {
        if (StringUtil.isNullOrEmpty(serviceName)) {
            serviceName = "/";
        }
        String[] _packageNames = new String[packageNames.length + 1];
        _packageNames[_packageNames.length - 1] = "io.baltoro.client.APITest";
        for (int i = 0; i < packageNames.length; ++i) {
            _packageNames[i] = packageNames[i];
        }
        ServicePackage sp = new ServicePackage(serviceName, _packageNames);
        serviceList.add(sp);
        serviceNames.append(serviceName + ",");
    }

    public static void pullReplication(String ... serviceName) {
        for (int i = 0; i < serviceName.length; ++i) {
            pullReplicationServiceNames = serviceName[i] + " ";
        }
        pullReplicationServiceNames = pullReplicationServiceNames.substring(0, pullReplicationServiceNames.length() - 1);
    }

    public static void start() {
        try {
            Baltoro.processEnv();
            Baltoro.buildService();
            cs.sendAppAPI();
            RequestPoller.instance();
            responsePoller = new ResponsePoller();
            responsePoller.start();
            running = true;
            for (ServicePackage sp : serviceList) {
                log.info("=====================================================");
                log.info("=====================================================");
                if (env == Env.LOC) {
                    log.info("Test URL --> " + serverURL + "/" + sp.serviceName + "/helloworld?appName=" + appName);
                } else {
                    log.info("Test URL --> " + serverURL + "/" + sp.serviceName + "/helloworld");
                    String hostUrl = serverURL.substring(0, serverURL.indexOf(46)) + "-hid" + hostId + "" + serverURL.substring(serverURL.indexOf(46));
                    log.info("Host URL --> " + hostUrl + "/" + sp.serviceName + "/helloworld");
                }
                log.info("HOST ID ====> " + hostId);
                log.info("INST UUID ====> " + instanceUuid);
                log.info("=====================================================");
                log.info("=====================================================");
            }
            db = LocalDB.instance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void processEnv() throws Exception {
        Properties hostProps = new Properties();
        String hostPropFileName = System.getProperty("user.home") + "/baltoro_host.env";
        File hostPropFile = new File(hostPropFileName);
        if (!hostPropFile.exists()) {
            hostPropFile.createNewFile();
        }
        hostProps.load(new FileInputStream(hostPropFile));
        hostId = hostProps.getProperty("baltoro.host.id");
        if (StringUtil.isNullOrEmpty(hostId)) {
            hostId = "" + (999 + new Random().nextInt(8999));
            hostProps.put("baltoro.host.id", hostId);
            FileOutputStream output = new FileOutputStream(hostPropFile);
            hostProps.store(output, "");
        }
        cs = new APIClient();
        props = new Properties();
        String propName = Baltoro.getMainClassName();
        String fileName = propName + "-" + env.toString().toUpperCase() + ".env";
        System.out.println(fileName);
        propFile = new File(fileName);
        if (!propFile.exists()) {
            propFile.createNewFile();
        }
        props.load(new FileInputStream(propFile));
        appUuid = props.getProperty("app.uuid");
        String _appUuid = cs.getAppUuidByName(appName);
        if (StringUtil.isNullOrEmpty(_appUuid) || appUuid == null || !appUuid.equals(_appUuid)) {
            props.put("app.uuid", _appUuid);
            appUuid = _appUuid;
        }
        if (StringUtil.isNullOrEmpty(appPrivateKey = props.getProperty("app.key"))) {
            String appKey = cs.getAppData(appUuid);
            props.put("app.key", appKey);
            appPrivateKey = appKey;
        }
        instanceUuid = props.getProperty("app.instance.uuid");
        String _instanceUuid = cs.createInstance(_appUuid, serviceNames.toString(), instanceUuid);
        if (StringUtil.isNullOrEmpty(_instanceUuid) || instanceUuid == null || !instanceUuid.equals(_instanceUuid)) {
            props.put("app.instance.uuid", _instanceUuid);
            instanceUuid = _instanceUuid;
        }
        if (instanceUuid == null || instanceUuid.equals("NOT ALLOWED")) {
            System.out.println("can't find or create an instance exiting " + appName);
            System.exit(1);
        }
        props.put("app.name", appName);
        props.put("app.env", env.toString());
        props.put("app.service.names", serviceNames.toString());
        props.put("app.server.url", serverURL);
        FileOutputStream output = new FileOutputStream(propFile);
        props.store(output, "For App " + appName.toUpperCase());
    }

    static String systemIn(String msg) {
        try {
            System.out.print(msg);
            BufferedReader bufferRead = new BufferedReader(new InputStreamReader(System.in));
            String input = bufferRead.readLine();
            return input;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tT:%4$s > %5$s%6$s%n");
        userSessionIdCtx = new ThreadLocal();
        userRequestCtx = new ThreadLocal();
        userResponseCtx = new ThreadLocal();
        serviceNameCtx = new ThreadLocal();
        pathClassMap = new HashMap(100);
        agentCookieMap = new HashMap<String, NewCookie>(100);
        serviceList = new ArrayList<ServicePackage>();
        serviceNames = new StringBuffer();
        instanceThreadCount = 3;
        props = null;
        serverURL = "http://www.baltoro.io";
        env = Env.PRD;
        serverDomain = "baltoro.io";
        serverPort = 80;
        serverProtocol = "http";
        running = false;
    }
}

