/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.db;

import io.baltoro.client.Replicator;
import io.baltoro.to.ReplicationTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PreparedStatement {
    private java.sql.PreparedStatement stmt;
    List<ReplicationTO> repList = null;

    public PreparedStatement(java.sql.PreparedStatement stmt) {
        this.stmt = stmt;
    }

    public boolean executeAndReplicate(String ... att) throws SQLException {
        boolean x = this.stmt.execute();
        Replicator.push(this.stmt, att);
        return x;
    }

    public boolean executeNoReplicate() throws SQLException {
        boolean x = this.stmt.execute();
        return x;
    }

    public ResultSet executeQuery() throws SQLException {
        return this.stmt.executeQuery();
    }

    public void close() throws SQLException {
        this.stmt.close();
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.stmt.setString(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.stmt.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.stmt.setLong(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.stmt.setTimestamp(parameterIndex, x);
    }

    public void addbatch(String ... att) throws SQLException {
        if (this.repList == null) {
            this.repList = new ArrayList<ReplicationTO>();
        }
        ReplicationTO repTO = Replicator.create(Replicator.getSQL(this.stmt), att);
        this.repList.add(repTO);
        this.stmt.addBatch();
    }

    public void executeBatch() throws SQLException {
        HashSet<String> attSet = new HashSet<String>();
        StringBuffer sqls = new StringBuffer();
        StringBuffer attBuffer = new StringBuffer();
        for (ReplicationTO to : this.repList) {
            String[] item = to.att.split(" ");
            for (int i = 0; i < item.length; ++i) {
                attSet.add(item[i]);
            }
            sqls.append(to.cmd + ";\n");
        }
        sqls.delete(sqls.length() - 2, sqls.length());
        attSet.stream().forEach(a -> attBuffer.append(a + " "));
        Replicator.pushBatch(sqls.toString(), attBuffer.toString());
        this.stmt.executeBatch();
        this.repList = null;
    }

    public java.sql.PreparedStatement getStmt() {
        return this.stmt;
    }
}

