/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.db;

import io.baltoro.client.util.StringUtil;
import io.baltoro.db.Fields;
import io.baltoro.features.Column;
import io.baltoro.features.PK;
import io.baltoro.features.Table;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DBExecutor {
    static Map<String, List<Fields>> classTableMap = new HashMap<String, List<Fields>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Fields> getFields(Class<?> _class) throws Exception {
        String tableName = DBExecutor.getTableName(_class);
        List<Fields> list = classTableMap.get(tableName);
        if (list == null) {
            String string = tableName.intern();
            synchronized (string) {
                list = classTableMap.get(tableName);
                if (list == null) {
                    DBExecutor.processObject(_class);
                    list = classTableMap.get(tableName);
                }
            }
        }
        if (list == null || list.isEmpty()) {
            throw new Exception("no columns or table ");
        }
        return list;
    }

    public static void insert(Connection con, Object obj) throws Exception {
        String tableName = DBExecutor.getTableName(obj.getClass());
        List<Fields> list = DBExecutor.getFields(obj.getClass());
        StringBuffer q = new StringBuffer();
        q.append("insert into " + tableName + " (");
        for (Fields f : list) {
            q.append(f.colName + ",");
        }
        q.delete(q.length() - 1, q.length());
        q.append(")\n");
        q.append(" values (");
        for (Fields f : list) {
            q.append("?,");
        }
        q.delete(q.length() - 1, q.length());
        q.append(")\n");
        PreparedStatement st = con.prepareStatement(q.toString());
        for (int i = 0; i < list.size(); ++i) {
            Fields f = list.get(i);
            Object value = f.get.invoke(obj, new Object[0]);
            if (value instanceof Timestamp) {
                st.setTimestamp(i + 1, (Timestamp)value);
                continue;
            }
            if (value instanceof Boolean) {
                boolean v = (Boolean)value;
                st.setInt(i + 1, v ? 1 : 0);
                continue;
            }
            if (value instanceof Integer) {
                st.setInt(i + 1, (Integer)value);
                continue;
            }
            st.setString(i + 1, value == null ? "" : value.toString());
        }
        boolean e = st.execute();
        st.close();
    }

    public static void update(Connection con, Object obj) throws Exception {
        String tableName = DBExecutor.getTableName(obj.getClass());
        List<Fields> list = DBExecutor.getFields(obj.getClass());
        StringBuffer q = new StringBuffer();
        q.append("update " + tableName + " set ");
        for (Fields f : list) {
            if (f.pk) continue;
            q.append(f.colName + "=?,");
        }
        q.delete(q.length() - 1, q.length());
        q.append(" where ");
        for (Fields f : list) {
            if (!f.pk) continue;
            Iterator<Fields> value = f.get.invoke(obj, new Object[0]);
            q.append(f.colName + "='" + value.toString() + "' and ");
        }
        q.delete(q.length() - 4, q.length());
        PreparedStatement st = con.prepareStatement(q.toString());
        int i = 0;
        for (Fields f : list) {
            if (f.pk) continue;
            ++i;
            Object value = f.get.invoke(obj, new Object[0]);
            if (value instanceof Timestamp) {
                st.setTimestamp(i, (Timestamp)value);
                continue;
            }
            if (value instanceof Boolean) {
                boolean v = (Boolean)value;
                st.setInt(i, v ? 1 : 0);
                continue;
            }
            st.setString(i, value == null ? "" : value.toString());
        }
        boolean e = st.execute();
        st.close();
    }

    public static <T> T selectOne(Connection con, Class<T> _class, String query) throws Exception {
        List<Fields> list = DBExecutor.getFields(_class);
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery(query);
        Object obj = null;
        if (rs.next()) {
            obj = _class.newInstance();
            for (Fields f : list) {
                int a;
                Object o = f.field.getType() == Timestamp.class ? rs.getTimestamp(f.colName) : (f.field.getType() == Integer.TYPE ? Integer.valueOf(rs.getInt(f.colName)) : (f.field.getType() == Boolean.TYPE ? Boolean.valueOf((a = rs.getInt(f.colName)) == 1) : rs.getString(f.colName)));
                Method m = f.set;
                m.invoke(obj, o);
            }
        }
        rs.close();
        st.close();
        return _class.cast(obj);
    }

    public static <T> List<T> select(Connection con, Class<T> _class, String query) throws Exception {
        System.out.println("query start ..... " + query);
        List<Fields> fList = DBExecutor.getFields(_class);
        ArrayList<T> rList = new ArrayList<T>(300);
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery(query);
        Object obj = null;
        while (rs.next()) {
            obj = _class.newInstance();
            for (Fields f : fList) {
                int a;
                Object o = f.field.getType() == Timestamp.class ? rs.getTimestamp(f.colName) : (f.field.getType() == Integer.TYPE ? Integer.valueOf(rs.getInt(f.colName)) : (f.field.getType() == Boolean.TYPE ? Boolean.valueOf((a = rs.getInt(f.colName)) == 1) : rs.getString(f.colName)));
                Method m = f.set;
                m.invoke(obj, o);
            }
            rList.add(_class.cast(obj));
        }
        rs.close();
        st.close();
        System.out.println("query end ..... " + query);
        return rList;
    }

    private static String getTableName(Class<?> _class) throws Exception {
        Table tableAnno = _class.getAnnotation(Table.class);
        if (tableAnno == null) {
            throw new Exception("No Table annotation");
        }
        return tableAnno.value();
    }

    private static void processObject(Class<?> _class) throws Exception {
        Field[] fields;
        Table tableAnno = _class.getAnnotation(Table.class);
        if (tableAnno == null) {
            throw new Exception("No Table annotation");
        }
        String tabelName = tableAnno.value();
        ArrayList<Fields> fieldList = new ArrayList<Fields>();
        for (Field field : fields = _class.getDeclaredFields()) {
            String getMethodName;
            Column colAnno = field.getAnnotation(Column.class);
            if (colAnno == null) continue;
            String colName = colAnno.value();
            Method getMethod = null;
            Class<?> fieldType = field.getType();
            String fieldName = field.getName();
            if (fieldType == Boolean.TYPE) {
                getMethodName = "is" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                getMethod = _class.getMethod(getMethodName, new Class[0]);
            } else {
                getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                getMethod = _class.getMethod(getMethodName, new Class[0]);
            }
            String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method setMethod = _class.getMethod(setMethodName, fieldType);
            Fields f = new Fields();
            f.get = getMethod;
            f.set = setMethod;
            f.field = field;
            f.colName = StringUtil.isNullOrEmpty(colName) ? field.getName() : colName;
            PK pk = field.getAnnotation(PK.class);
            if (pk != null) {
                f.pk = true;
            }
            fieldList.add(f);
        }
        classTableMap.put(tabelName, fieldList);
    }
}

