/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.WSSessions;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.OnClose;
import javax.websocket.Session;

public class BaltoroClientEndpointWSWeb
extends Endpoint {
    private static Logger log = Logger.getLogger(BaltoroClientEndpointWSWeb.class.getName());
    private String appName;
    private String path;
    MessageHandler.Whole<ByteBuffer> handlerClass;

    public BaltoroClientEndpointWSWeb(String appName, String path, MessageHandler.Whole<ByteBuffer> handlerClass) {
        this.appName = appName;
        this.path = path;
        this.handlerClass = handlerClass;
    }

    @Override
    public void onOpen(Session session, EndpointConfig config) {
        log.info(" ******** Connected ... " + session.getId());
        session.addMessageHandler(this.handlerClass);
    }

    @Override
    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        WSSessions.get().removeSession(session);
        try {
            log.info(String.format("Session %s close because of %s", session, closeReason));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

