/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.baltoro.client.Baltoro;
import io.baltoro.client.RequestWorker;
import io.baltoro.client.WorkerPool;
import io.baltoro.client.util.StringUtil;
import io.baltoro.to.WSTO;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;

public class RequestPoller
extends Thread {
    boolean run = true;
    static ObjectMapper mapper = new ObjectMapper();
    OperatingSystemMXBean os = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    MemoryMXBean mem = ManagementFactory.getPlatformMXBean(MemoryMXBean.class);

    @Override
    public void run() {
        while (this.run) {
            int cpu = (int)this.os.getSystemLoadAverage();
            long maxMem = (int)this.mem.getHeapMemoryUsage().getCommitted();
            long usedMem = (int)this.mem.getHeapMemoryUsage().getUsed();
            int freeMem = (int)(maxMem - usedMem) / 1000000;
            String json = null;
            try {
                json = Baltoro.cs.poll(cpu, freeMem);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            if (StringUtil.isNullOrEmpty(json)) continue;
            WSTO[] tos = this.readData(json);
            for (int i = 0; i < tos.length; ++i) {
                WSTO to = tos[i];
                RequestWorker worker = WorkerPool.getRequestWorker();
                if (worker == null) {
                    worker = new RequestWorker();
                    worker.start();
                }
                worker.set(to);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep(String text) {
        try {
            long t0 = System.currentTimeMillis();
            String sync = "request-queue";
            String string = sync.intern();
            synchronized (string) {
                sync.intern().wait(50000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private WSTO[] readData(String json) {
        byte[] jsonBytes = json.getBytes();
        WSTO[] tos = null;
        try {
            tos = mapper.readValue(jsonBytes, WSTO[].class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return tos;
    }
}

