/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.Baltoro;
import io.baltoro.to.SessionUserTO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UserSession {
    private final String sessionId;
    Map<String, String> attMap = new HashMap<String, String>(200);
    Set<String> roles = new HashSet<String>();
    String userName;
    private boolean authenticated;

    UserSession(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getAttribute(String name) {
        return this.attMap.get(name);
    }

    public void addAttribute(String name, String value) {
        this.attMap.put(name, value);
        this.sendSession();
    }

    public void addRoles(String roleName) {
        this.roles.add(roleName);
        this.sendSession();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUserName() {
        return this.userName;
    }

    boolean isAuthenticated() {
        return this.authenticated;
    }

    void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    void sendSession() {
        SessionUserTO to = new SessionUserTO();
        to.sessionUuid = this.getSessionId();
        to.userName = this.getUserName();
        to.authenticated = this.authenticated;
        to.roles = this.roles;
        to.att = this.attMap;
        try {
            Baltoro.cs.validateSession(this.getSessionId(), to);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

