/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.Baltoro;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.HandshakeResponse;
import javax.ws.rs.core.NewCookie;

public class BaltoroClientConfig
extends ClientEndpointConfig.Configurator {
    static Logger log = Logger.getLogger(BaltoroClientConfig.class.getName());
    static volatile boolean called = false;
    private Map<String, NewCookie> cookieMap;
    private String token;

    public BaltoroClientConfig(Map<String, NewCookie> cookieMap, String token) {
        this.cookieMap = cookieMap;
        this.token = token;
    }

    @Override
    public void beforeRequest(Map<String, List<String>> headers) {
        called = true;
        for (String key : this.cookieMap.keySet()) {
            NewCookie cookie = this.cookieMap.get(key);
            log.info("seinding WS +++++ >>>>>>>>>>> key[" + key + "]:" + cookie);
            headers.put("Cookie", Arrays.asList(cookie.toString()));
        }
        headers.put("BLT_APP_UUID", Arrays.asList(Baltoro.appUuid));
        headers.put("BLT_INSTANCE_UUID", Arrays.asList(Baltoro.instanceUuid));
        headers.put("BLT_TOKEN", Arrays.asList(this.token));
        headers.put("BLT_APP_NAME", Arrays.asList(Baltoro.appName));
        headers.put("BLT_SERVICE_NAME", Arrays.asList(Baltoro.serviceNames.toString()));
    }

    @Override
    public void afterResponse(HandshakeResponse handshakeResponse) {
        Map<String, List<String>> headers = handshakeResponse.getHeaders();
    }
}

