/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.AnnotationProcessor;
import io.baltoro.client.BOAPIClient;
import io.baltoro.client.Env;
import io.baltoro.client.LocalDB;
import io.baltoro.client.RequestPoller;
import io.baltoro.client.RequestWorker;
import io.baltoro.client.ResponsePoller;
import io.baltoro.client.ServicePackage;
import io.baltoro.client.SessionManager;
import io.baltoro.client.UserSession;
import io.baltoro.client.WSSessions;
import io.baltoro.client.WebMethod;
import io.baltoro.client.WebMethodMap;
import io.baltoro.ep.ClassBuilder;
import io.baltoro.ep.CloudServer;
import io.baltoro.ep.EPData;
import io.baltoro.ep.ParamInput;
import io.baltoro.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.websocket.Session;
import javax.ws.rs.core.NewCookie;

public class Baltoro {
    static Logger log = Logger.getLogger(Baltoro.class.getName());
    static Map<String, Class<?>> pathClassMap;
    static Map<String, NewCookie> agentCookieMap;
    static List<ServicePackage> serviceList;
    static StringBuffer serviceNames;
    static String hostId;
    static BOAPIClient cs;
    static String instanceUuid;
    static int instanceThreadCount;
    static Properties props;
    static String appUuid;
    static String appPrivateKey;
    static String appName;
    static String userUuid;
    static File propFile;
    static String serverURL;
    static Env env;
    static String serverDomain;
    static int serverPort;
    static String serverProtocol;
    static RequestPoller requestPoller;
    static ResponsePoller responsePoller;
    static String lcp;
    static long repMillis;

    private static void buildService() throws Exception {
        HashMap<String, WebMethod> pathMap = new HashMap<String, WebMethod>(200);
        AnnotationProcessor p = new AnnotationProcessor();
        for (ServicePackage sp : serviceList) {
            for (String _package : sp.packageNames) {
                Map<String, WebMethod> pMap = p.processAnnotation(sp.serviceName, _package);
                pathMap.putAll(pMap);
            }
            WebMethodMap.getInstance().setMap(pathMap);
        }
    }

    private static Session startWSClient() throws Exception {
        int count = 1;
        ExecutorService executor = Executors.newFixedThreadPool(count);
        for (int i = 0; i < count; ++i) {
            Future future = null;
            Session session = (Session)future.get();
            WSSessions.get().addSession(session);
            log.info(" >>>>>>>>>>>>>>>>>>>>>>>>>>> started client THREAD : " + session.getId() + " ,,, i=" + i);
        }
        return null;
    }

    public static LocalDB getDB() {
        return LocalDB.instance(false, false);
    }

    public static LocalDB getDB(boolean clean, boolean replicate) {
        return LocalDB.instance(clean, replicate);
    }

    public static String getMainClassName() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        StackTraceElement ste = stElements[stElements.length - 1];
        return ste.getClassName();
    }

    public static Env getEnv() {
        return env;
    }

    public static String getMainClassPackageName() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        StackTraceElement ste = stElements[stElements.length - 1];
        String className = ste.getClassName();
        System.out.println(" ---- > " + className);
        String[] packs = className.split("\\.");
        if (packs.length > 1) {
            return packs[0] + "." + packs[1];
        }
        return packs[0];
    }

    public static <T> T endPointFactory(Class<T> _class) {
        try {
            Class<?> implClass = pathClassMap.get(_class.getName());
            if (implClass == null) {
                ClassBuilder builder = new ClassBuilder(_class);
                implClass = builder.buildClass();
                pathClassMap.put(_class.getName(), implClass);
            }
            Object obj = implClass.newInstance();
            return _class.cast(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T callSync(String appName, String path, Class<T> returnType) {
        return Baltoro.callSync(appName, path, returnType, null);
    }

    public static <T> T callSync(String appName, String path, Class<T> returnType, ParamInput input) {
        try {
            CloudServer cServer = new CloudServer(appName);
            EPData epData = null;
            if (input != null) {
                epData = input.getEPData();
            }
            T t = cServer.call(path, epData, returnType);
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Future<?> callAsync(String appName, String path, Class<?> returnType) {
        return Baltoro.callAsync(appName, path, returnType, null);
    }

    public static Future<?> callAsync(String appName, String path, Class<?> returnType, ParamInput input) {
        try {
            CloudServer cServer = new CloudServer(appName);
            EPData epData = null;
            if (input != null) {
                epData = input.getEPData();
            }
            Future<?> f = cServer.callAsyn(path, epData, returnType);
            return f;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setUserToSession(String name) {
        String userSessionId = RequestWorker.userSessionIdCtx.get();
        if (userSessionId == null) {
            return;
        }
        UserSession userSession = SessionManager.getSession(userSessionId);
        userSession.userName = name;
        userSession.sendSession();
    }

    public static UserSession getUserSession() {
        String userSessionId = RequestWorker.userSessionIdCtx.get();
        if (userSessionId == null) {
            return null;
        }
        UserSession userSession = SessionManager.getSession(userSessionId);
        return userSession;
    }

    public static void invalidateSession() {
        String userSessionId = RequestWorker.userSessionIdCtx.get();
        if (userSessionId == null) {
            return;
        }
        UserSession userSession = SessionManager.getSession(userSessionId);
        userSession.userName = null;
        userSession.invlaidateSession = true;
        SessionManager.removeUserSession(userSessionId);
        userSession.sendSession();
    }

    public static void init(String appName) {
        Baltoro.init(appName, null);
    }

    public static void init(String appName, Env env) {
        String _envStr = System.getProperties().getProperty("env");
        if (StringUtil.isNotNullAndNotEmpty(_envStr)) {
            Env _env = null;
            try {
                _env = Env.valueOf(_envStr.toUpperCase());
            }
            catch (Exception e) {
                System.out.println("Check JVM argument -Denv=? ALLOWED env values are " + Arrays.toString((Object[])Env.values()));
                System.out.println("shut down ...");
                System.exit(1);
            }
            Baltoro.env = _env;
        } else {
            Baltoro.env = env;
        }
        if (env == null) {
            env = Env.PRD;
        }
        switch (env) {
            case PRD: {
                serverURL = serverProtocol + "://" + appName + "." + serverDomain + ":" + serverPort;
                break;
            }
            case STG: {
                serverURL = serverProtocol + "://" + appName + "-stg." + serverDomain + ":" + serverPort;
                break;
            }
            case QA: {
                serverURL = serverProtocol + "://" + appName + "-qa." + serverDomain + ":" + serverPort;
                break;
            }
            case DEV: {
                serverURL = serverProtocol + "://" + appName + "-dev." + serverDomain + ":" + serverPort;
                break;
            }
            case LOC: {
                serverURL = "http://localhost:8080";
                break;
            }
            default: {
                serverURL = serverProtocol + "://www.baltoro.io";
            }
        }
        Baltoro.appName = appName;
    }

    public static void register(String serviceName, String ... packageNames) {
        if (StringUtil.isNullOrEmpty(serviceName)) {
            serviceName = "/";
        }
        ServicePackage sp = new ServicePackage(serviceName, packageNames);
        serviceList.add(sp);
        serviceNames.append(serviceName + ",");
    }

    public static void start() {
        try {
            Baltoro.processEnv();
            Baltoro.buildService();
            cs.sendAppAPI();
            requestPoller = new RequestPoller();
            requestPoller.start();
            responsePoller = new ResponsePoller();
            responsePoller.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void processEnv() throws Exception {
        cs = new BOAPIClient();
        props = new Properties();
        String propName = Baltoro.getMainClassName();
        String fileName = propName + "-" + env.toString().toUpperCase() + ".env";
        System.out.println(fileName);
        propFile = new File(fileName);
        if (!propFile.exists()) {
            propFile.createNewFile();
        }
        props.load(new FileInputStream(propFile));
        appUuid = props.getProperty("app.uuid");
        String _appUuid = cs.getAppUuidByName(appName);
        if (StringUtil.isNullOrEmpty(_appUuid) || appUuid == null || !appUuid.equals(_appUuid)) {
            props.put("app.uuid", _appUuid);
            appUuid = _appUuid;
        }
        if (StringUtil.isNullOrEmpty(appPrivateKey = props.getProperty("app.key"))) {
            String appKey = cs.getAppData(appUuid);
            props.put("app.key", appKey);
            appPrivateKey = appKey;
        }
        instanceUuid = props.getProperty("app.instance.uuid");
        String _instanceUuid = cs.createInstance(_appUuid, serviceNames.toString(), instanceUuid);
        if (StringUtil.isNullOrEmpty(_instanceUuid) || instanceUuid == null || !instanceUuid.equals(_instanceUuid)) {
            props.put("app.instance.uuid", _instanceUuid);
            instanceUuid = _instanceUuid;
        }
        if (instanceUuid == null || instanceUuid.equals("NOT ALLOWED")) {
            System.out.println("can't find or create an instance exiting " + appName);
            System.exit(1);
        }
        if (StringUtil.isNullOrEmpty(hostId = props.getProperty("app.host.id"))) {
            hostId = "" + (999 + new Random().nextInt(8999));
            props.put("app.host.id", hostId);
        }
        props.put("app.name", appName);
        props.put("app.env", env.toString());
        props.put("app.service.names", serviceNames.toString());
        props.put("app.server.url", serverURL);
        FileOutputStream output = new FileOutputStream(propFile);
        props.store(output, "For App " + appName.toUpperCase());
    }

    static String systemIn(String msg) {
        try {
            System.out.print(msg);
            BufferedReader bufferRead = new BufferedReader(new InputStreamReader(System.in));
            String input = bufferRead.readLine();
            return input;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tT:%4$s > %5$s%6$s%n");
        pathClassMap = new HashMap(100);
        agentCookieMap = new HashMap<String, NewCookie>(100);
        serviceList = new ArrayList<ServicePackage>();
        serviceNames = new StringBuffer();
        instanceThreadCount = 3;
        props = null;
        serverURL = "http://www.baltoro.io";
        env = Env.PRD;
        serverDomain = "baltoro.io";
        serverPort = 80;
        serverProtocol = "http";
    }
}

