/*
 * Decompiled with CFR 0.152.
 */
package io.baltoro.client;

import io.baltoro.client.AnnotationProcessor;
import io.baltoro.client.BOAPIClient;
import io.baltoro.client.Env;
import io.baltoro.client.LocalDB;
import io.baltoro.client.RequestPoller;
import io.baltoro.client.RequestWorker;
import io.baltoro.client.ResponsePoller;
import io.baltoro.client.ServicePackage;
import io.baltoro.client.SessionManager;
import io.baltoro.client.UserSession;
import io.baltoro.client.WSSessions;
import io.baltoro.client.WebMethod;
import io.baltoro.client.WebMethodMap;
import io.baltoro.ep.ClassBuilder;
import io.baltoro.ep.CloudServer;
import io.baltoro.ep.EPData;
import io.baltoro.ep.ParamInput;
import io.baltoro.to.APIError;
import io.baltoro.to.AppTO;
import io.baltoro.to.UserTO;
import io.baltoro.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.websocket.Session;
import javax.ws.rs.core.NewCookie;

public class Baltoro {
    static Logger log = Logger.getLogger(Baltoro.class.getName());
    static Map<String, Class<?>> pathClassMap;
    static Map<String, NewCookie> agentCookieMap;
    static List<ServicePackage> serviceList;
    static StringBuffer serviceNames;
    static String hostId;
    static BOAPIClient cs;
    private static boolean logedin;
    private static String email;
    private static String password;
    private static UserTO user;
    static String instanceUuid;
    static int instanceThreadCount;
    static Properties props;
    static String appUuid;
    static String appPrivateKey;
    static String appName;
    static String userUuid;
    static File propFile;
    static String serverURL;
    static Env env;
    static RequestPoller requestPoller;
    static ResponsePoller responsePoller;
    static String lcp;
    static long repMillis;

    private static void buildService() throws Exception {
        HashMap<String, WebMethod> pathMap = new HashMap<String, WebMethod>(200);
        AnnotationProcessor p = new AnnotationProcessor();
        for (ServicePackage sp : serviceList) {
            for (String _package : sp.packageNames) {
                Map<String, WebMethod> pMap = p.processAnnotation(sp.serviceName, _package);
                pathMap.putAll(pMap);
            }
            WebMethodMap.getInstance().setMap(pathMap);
        }
    }

    private static Session startWSClient() throws Exception {
        int count = 1;
        ExecutorService executor = Executors.newFixedThreadPool(count);
        for (int i = 0; i < count; ++i) {
            Future future = null;
            Session session = (Session)future.get();
            WSSessions.get().addSession(session);
            log.info(" >>>>>>>>>>>>>>>>>>>>>>>>>>> started client THREAD : " + session.getId() + " ,,, i=" + i);
        }
        return null;
    }

    public static LocalDB getDB() {
        return LocalDB.instance(false, false);
    }

    public static LocalDB getDB(boolean clean, boolean replicate) {
        return LocalDB.instance(clean, replicate);
    }

    public static String getMainClassName() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        StackTraceElement ste = stElements[stElements.length - 1];
        return ste.getClassName();
    }

    public static Env getEnv() {
        return env;
    }

    public static String getMainClassPackageName() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        StackTraceElement ste = stElements[stElements.length - 1];
        String className = ste.getClassName();
        System.out.println(" ---- > " + className);
        String[] packs = className.split("\\.");
        if (packs.length > 1) {
            return packs[0] + "." + packs[1];
        }
        return packs[0];
    }

    public static <T> T endPointFactory(Class<T> _class) {
        try {
            Class<?> implClass = pathClassMap.get(_class.getName());
            if (implClass == null) {
                ClassBuilder builder = new ClassBuilder(_class);
                implClass = builder.buildClass();
                pathClassMap.put(_class.getName(), implClass);
            }
            Object obj = implClass.newInstance();
            return _class.cast(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T callSync(String appName, String path, Class<T> returnType) {
        return Baltoro.callSync(appName, path, returnType, null);
    }

    public static <T> T callSync(String appName, String path, Class<T> returnType, ParamInput input) {
        try {
            CloudServer cServer = new CloudServer(appName);
            EPData epData = null;
            if (input != null) {
                epData = input.getEPData();
            }
            T t = cServer.call(path, epData, returnType);
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Future<?> callAsync(String appName, String path, Class<?> returnType) {
        return Baltoro.callAsync(appName, path, returnType, null);
    }

    public static Future<?> callAsync(String appName, String path, Class<?> returnType, ParamInput input) {
        try {
            CloudServer cServer = new CloudServer(appName);
            EPData epData = null;
            if (input != null) {
                epData = input.getEPData();
            }
            Future<?> f = cServer.callAsyn(path, epData, returnType);
            return f;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setUserToSession(String name) {
        String userSessionId = RequestWorker.userSessionIdCtx.get();
        if (userSessionId == null) {
            return;
        }
        UserSession userSession = SessionManager.getSession(userSessionId);
        userSession.userName = name;
        userSession.sendSession();
    }

    public static UserSession getUserSession() {
        String userSessionId = RequestWorker.userSessionIdCtx.get();
        if (userSessionId == null) {
            return null;
        }
        UserSession userSession = SessionManager.getSession(userSessionId);
        return userSession;
    }

    public static void invalidateSession() {
        String userSessionId = RequestWorker.userSessionIdCtx.get();
        if (userSessionId == null) {
            return;
        }
        UserSession userSession = SessionManager.getSession(userSessionId);
        userSession.userName = null;
        userSession.invlaidateSession = true;
        SessionManager.removeUserSession(userSessionId);
        userSession.sendSession();
    }

    public static void init(String appName) {
        Baltoro.init(appName, Env.PRD);
    }

    public static void init(String appName, Env env) {
        Baltoro.env = env;
        switch (env) {
            case PRD: {
                serverURL = "http://" + appName + ".baltoro.io";
                break;
            }
            case STG: {
                serverURL = "http://" + appName + "-stg.baltoro.io";
                break;
            }
            case QA: {
                serverURL = "http://" + appName + "-qa.baltoro.io";
                break;
            }
            case DEV: {
                serverURL = "http://" + appName + "-dev.baltoro.io";
                break;
            }
            case LOC: {
                serverURL = "http://localhost:8080";
                break;
            }
            default: {
                serverURL = "http://admin.baltoro.io";
            }
        }
        Baltoro.appName = appName;
    }

    public static void register(String serviceName, String ... packageNames) {
        if (StringUtil.isNullOrEmpty(serviceName)) {
            serviceName = "/";
        }
        ServicePackage sp = new ServicePackage(serviceName, packageNames);
        serviceList.add(sp);
        serviceNames.append(serviceName + ",");
    }

    private static Session start_old() {
        try {
            boolean loaded = Baltoro.loadProperties();
            if (!loaded) {
                FileOutputStream output = new FileOutputStream(propFile);
                appUuid = cs.getAppUuidByName(appName);
                props.put("app.uuid", appUuid);
                String instUuid = cs.createInstance(appUuid, serviceNames.toString());
                if (instUuid == null || instUuid.equals("NOT ALLOWED")) {
                    System.out.println("can't find or create an instance exiting " + appName);
                    System.exit(1);
                }
                instanceUuid = instUuid;
                props.put("app.instance.uuid", instUuid);
                String appKey = cs.getAppData(appUuid);
                props.put("app.key", appKey);
                hostId = "" + new Random().nextInt();
                props.put("app.host.id", hostId);
                props.store(output, "updated on " + new Date());
            }
            Baltoro.buildService();
            Session session = Baltoro.startWSClient();
            return session;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void start() {
        try {
            boolean loaded = Baltoro.loadProperties();
            if (!loaded) {
                FileOutputStream output = new FileOutputStream(propFile);
                appUuid = cs.getAppUuidByName(appName);
                props.put("app.uuid", appUuid);
                String instUuid = cs.createInstance(appUuid, serviceNames.toString());
                if (instUuid == null || instUuid.equals("NOT ALLOWED")) {
                    System.out.println("can't find or create an instance exiting " + appName);
                    System.exit(1);
                }
                instanceUuid = instUuid;
                props.put("app.instance.uuid", instUuid);
                String appKey = cs.getAppData(appUuid);
                props.put("app.key", appKey);
                hostId = "" + new Random().nextInt();
                props.put("app.host.id", hostId);
                props.store(output, "updated on " + new Date());
            }
            Baltoro.buildService();
            cs.sendAppAPI();
            requestPoller = new RequestPoller();
            requestPoller.start();
            responsePoller = new ResponsePoller();
            responsePoller.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
    }

    private static boolean loadProperties() throws Exception {
        cs = new BOAPIClient();
        props = new Properties();
        String propName = Baltoro.getMainClassName();
        String fileName = propName + ".props";
        System.out.println(fileName);
        propFile = new File(fileName);
        if (propFile.exists()) {
            props.load(new FileInputStream(propFile));
            appPrivateKey = props.getProperty("app.key");
            if (StringUtil.isNullOrEmpty(appPrivateKey)) {
                return false;
            }
            appUuid = props.getProperty("app.uuid");
            if (StringUtil.isNullOrEmpty(appUuid)) {
                return false;
            }
            String _appUuid = cs.getAppUuidByName(appName);
            if (StringUtil.isNullOrEmpty(_appUuid) || !appUuid.equals(_appUuid)) {
                return false;
            }
            instanceUuid = props.getProperty("app.instance.uuid");
            if (StringUtil.isNullOrEmpty(instanceUuid)) {
                return false;
            }
            String _instanceUuid = cs.instanceCreated(instanceUuid);
            if (StringUtil.isNullOrEmpty(_instanceUuid) || !"YES".equals(_instanceUuid)) {
                return false;
            }
            hostId = props.getProperty("app.host.id");
            return !StringUtil.isNullOrEmpty(hostId);
        }
        return false;
    }

    private static AppTO getMyApp() throws Exception {
        if (!logedin) {
            return null;
        }
        boolean newApp = true;
        AppTO selectApp = null;
        AppTO[] apps = Baltoro.callSync("admin", "/api/app/getMyApps", AppTO[].class, a -> a);
        if (apps.length > 0) {
            newApp = false;
            System.out.println(" ========  apps ========= ");
            System.out.println("0 -- to create new app : ");
            System.out.println(" ======== exisiting apps ========= ");
            int i = 1;
            for (AppTO appTO : apps) {
                System.out.println(i++ + " -- to start app : " + appTO.name);
            }
            String option = Baltoro.systemIn("enter option : ");
            if (option.equals("0")) {
                newApp = true;
            } else {
                int opt = Integer.parseInt(option);
                selectApp = apps[opt - 1];
                System.out.println("selected app : " + selectApp.name);
            }
        }
        if (newApp) {
            AppTO to = null;
            for (int i = 0; i < 5; ++i) {
                try {
                    String name = Baltoro.systemIn("enter name of your new app : ");
                    to = Baltoro.callSync("admin", "/api/app/createApp", AppTO.class, a -> a.add("name", name));
                    break;
                }
                catch (APIError e) {
                    System.out.println("************************");
                    System.out.println(e.getMessage());
                    System.out.println("************************");
                    continue;
                }
            }
            if (to == null) {
                System.out.println("5 tries, restart the app again");
                System.exit(1);
            }
            selectApp = to;
        }
        System.out.println(" =-==== " + selectApp.privateDataUuid);
        props.put("app.uuid", selectApp.uuid);
        props.put("app.name", selectApp.name);
        return selectApp;
    }

    static String systemIn(String msg) {
        try {
            System.out.print(msg);
            BufferedReader bufferRead = new BufferedReader(new InputStreamReader(System.in));
            String input = bufferRead.readLine();
            return input;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tT:%4$s > %5$s%6$s%n");
        pathClassMap = new HashMap(100);
        agentCookieMap = new HashMap<String, NewCookie>(100);
        serviceList = new ArrayList<ServicePackage>();
        serviceNames = new StringBuffer();
        logedin = false;
        instanceThreadCount = 3;
        props = null;
        serverURL = "http://www.baltoro.io";
        env = Env.PRD;
    }
}

