/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class ReferencedKeyConstraintDescriptor
extends KeyConstraintDescriptor {
    private final int constraintType;
    int referenceCount;
    private ConstraintDescriptorList fkEnabledConstraintList;
    private ConstraintDescriptorList fkConstraintList;
    private boolean checkedSelfReferencing;
    private boolean hasSelfReferencing;

    protected ReferencedKeyConstraintDescriptor(int n, DataDictionary dataDictionary, TableDescriptor tableDescriptor, String string, boolean bl, boolean bl2, int[] nArray, UUID uUID, UUID uUID2, SchemaDescriptor schemaDescriptor, boolean bl3, int n2) {
        super(dataDictionary, tableDescriptor, string, bl, bl2, nArray, uUID, uUID2, schemaDescriptor, bl3);
        this.referenceCount = n2;
        this.constraintType = n;
    }

    @Override
    public final int getConstraintType() {
        return this.constraintType;
    }

    public boolean hasSelfReferencingFK(ConstraintDescriptorList constraintDescriptorList, int n) throws StandardException {
        if (this.checkedSelfReferencing) {
            return this.hasSelfReferencing;
        }
        if (constraintDescriptorList == null) {
            constraintDescriptorList = this.getForeignKeyConstraints(n);
        }
        for (ConstraintDescriptor constraintDescriptor : constraintDescriptorList) {
            ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor;
            if (!(constraintDescriptor instanceof ForeignKeyConstraintDescriptor) || !(foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)constraintDescriptor).getReferencedConstraintId().equals(this.getUUID())) continue;
            this.hasSelfReferencing = true;
            break;
        }
        return this.hasSelfReferencing;
    }

    public ConstraintDescriptorList getNonSelfReferencingFK(int n) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList = new ConstraintDescriptorList();
        for (ConstraintDescriptor constraintDescriptor : this.getForeignKeyConstraints(n)) {
            ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor;
            if (!(constraintDescriptor instanceof ForeignKeyConstraintDescriptor) || (foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)constraintDescriptor).getTableId().equals(this.getTableId())) continue;
            constraintDescriptorList.add(foreignKeyConstraintDescriptor);
        }
        return constraintDescriptorList;
    }

    public ConstraintDescriptorList getForeignKeyConstraints(int n) throws StandardException {
        if (n == 1) {
            if (!this.isReferenced()) {
                return new ConstraintDescriptorList();
            }
            if (this.fkEnabledConstraintList != null) {
                return this.fkEnabledConstraintList;
            }
            if (this.fkConstraintList == null) {
                this.fkConstraintList = this.getDataDictionary().getForeignKeys(this.constraintId);
            }
            this.fkEnabledConstraintList = this.fkConstraintList.getConstraintDescriptorList(true);
            return this.fkEnabledConstraintList;
        }
        if (n == 2) {
            if (this.fkConstraintList == null) {
                this.fkConstraintList = this.getDataDictionary().getForeignKeys(this.constraintId);
            }
            return this.fkConstraintList.getConstraintDescriptorList(false);
        }
        if (this.fkConstraintList == null) {
            this.fkConstraintList = this.getDataDictionary().getForeignKeys(this.constraintId);
        }
        return this.fkConstraintList;
    }

    @Override
    public boolean isReferenced() {
        return this.referenceCount != 0;
    }

    @Override
    public int getReferenceCount() {
        return this.referenceCount;
    }

    public int incrementReferenceCount() {
        return this.referenceCount++;
    }

    public int decrementReferenceCount() {
        return this.referenceCount--;
    }

    @Override
    public boolean needsToFire(int n, int[] nArray) {
        if (!this.enforced()) {
            return false;
        }
        if (!this.isReferenced() || n == 1) {
            return false;
        }
        if (n == 4 || n == 2) {
            return true;
        }
        return ReferencedKeyConstraintDescriptor.doColumnsIntersect(nArray, this.getReferencedColumns());
    }

    private void checkType(int n) throws StandardException {
    }
}

